/*
 * Decompiled with CFR 0.152.
 */
package com.naxanria.harvest;

import com.naxanria.harvest.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="harvest")
public class Harvest {
    public static final String MODID = "harvest";
    public static final Logger LOGGER = LogManager.getLogger((String)"harvest");

    public Harvest() {
        MinecraftForge.EVENT_BUS.addListener(this::onInteract);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.SPEC);
    }

    private void onInteract(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (event.getHand() == Hand.OFF_HAND) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Config config = Config.COMMON;
        List blacklist = (List)config.blacklist.get();
        boolean whitelist = (Boolean)config.whitelist.get();
        boolean consumeSeed = (Boolean)config.consumeSeed.get();
        if (blacklist.contains(block.getRegistryName().toString()) ? !whitelist : whitelist) {
            return;
        }
        if (block instanceof CropsBlock) {
            CropsBlock crop = (CropsBlock)block;
            if (crop.func_185525_y(state)) {
                if (!world.field_72995_K) {
                    List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, null);
                    ItemStack seed = crop.func_185473_a((IBlockReader)world, pos, state);
                    for (ItemStack drop : drops) {
                        if (consumeSeed && drop.func_77973_b() == seed.func_77973_b()) {
                            drop.func_190918_g(1);
                        }
                        if (drop.func_190926_b()) continue;
                        InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)drop);
                    }
                    world.func_180501_a(pos, crop.func_185528_e(0), 11);
                }
                event.setCanceled(true);
            }
        } else if (block == Blocks.field_150388_bm && ((Boolean)Config.COMMON.harvestNetherWart.get()).booleanValue() && (Integer)state.func_177229_b((Property)NetherWartBlock.field_176486_a) == 3) {
            if (!world.field_72995_K) {
                List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, null);
                for (ItemStack drop : drops) {
                    if (consumeSeed && drop.func_77973_b() == Items.field_151075_bm) {
                        drop.func_190918_g(1);
                    }
                    if (drop.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)drop);
                }
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(0)), 11);
            }
            event.setCanceled(true);
        }
    }
}

