/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd.util;

import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.jamd.block.PortalBlock;
import com.unrealdinnerbone.jamd.block.PortalTileEntity;
import com.unrealdinnerbone.jamd.util.SimpleTeleporter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class TelerportUtils {
    public static void teleport(Block clickedBlock, PlayerEntity playerEntity, World toWorld, BlockPos blockPos) throws RuntimeException {
        if (!toWorld.func_201670_d() && playerEntity.field_70170_p instanceof ServerWorld && toWorld instanceof ServerWorld) {
            BlockPos portalLocation = TelerportUtils.findPortalLocation(toWorld, blockPos).orElseThrow(() -> new RuntimeException("Cant find location to spawn portal"));
            if (toWorld.func_180495_p(portalLocation).func_196958_f()) {
                PortalBlock.placeBlock(clickedBlock, toWorld, portalLocation, (RegistryKey<World>)playerEntity.field_70170_p.func_234923_W_());
            }
            playerEntity.changeDimension((ServerWorld)toWorld, (ITeleporter)new SimpleTeleporter(portalLocation.func_177958_n(), portalLocation.func_177984_a().func_177956_o(), portalLocation.func_177952_p()));
        }
    }

    private static Optional<BlockPos> findPortalLocation(World worldTo, BlockPos fromPos) {
        if (worldTo.func_180495_p(fromPos).func_177230_c() == JAMDRegistry.MINE_PORTAL_BLOCK.get() && TelerportUtils.isSafeSpawnLocation(worldTo, fromPos)) {
            return Optional.of(fromPos.func_177984_a());
        }
        int range = 5;
        return Optional.ofNullable(ChunkPos.func_222243_a((ChunkPos)worldTo.func_175726_f(fromPos).func_76632_l(), (int)range).map(chunkPos -> worldTo.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b).func_203066_o()).flatMap(Collection::stream).collect(Collectors.toList()).stream().filter(pos -> worldTo.func_175625_s(pos) instanceof PortalTileEntity).findFirst().orElseGet(() -> {
            BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(0, 0, 0);
            for (int y = 0; y < 256; ++y) {
                for (int x = fromPos.func_177958_n() - 6; x < fromPos.func_177958_n() + 6; ++x) {
                    for (int z = fromPos.func_177952_p() - 6; z < fromPos.func_177952_p() + 6; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        BlockState blockState = worldTo.func_180495_p((BlockPos)mutableBlockPos);
                        if (!blockState.func_196958_f() || !TelerportUtils.isSafeSpawnLocation(worldTo, mutableBlockPos.func_177984_a())) continue;
                        return mutableBlockPos;
                    }
                }
            }
            return null;
        }));
    }

    private static boolean isSafeSpawnLocation(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_196958_f() && world.func_180495_p(blockPos.func_177984_a()).func_196958_f();
    }
}

