/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.client.gui.container.ContainerScreenPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartInterfaceCraftingSettings
extends ContainerScreenPartSettings<ContainerPartInterfaceCraftingSettings>
implements IInputListener {
    private WidgetArrowedListField<IngredientComponent<?, ?>> ingredientComponentSideSelector = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<ContainerScreenPartSettings.SideDropdownEntry> dropdownEntries;
    private IngredientComponent<?, ?> selectedIngredientComponent = null;
    private WidgetNumberField numberFieldChannelInterfaceCrafting = null;
    private ButtonCheckbox checkboxFieldDisabledCraftingCheck = null;

    public ContainerScreenPartInterfaceCraftingSettings(ContainerPartInterfaceCraftingSettings container, PlayerInventory inventory, ITextComponent title) {
        super((ContainerPartSettings)container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedcrafting", "textures/gui/part_interface_settings.png");
    }

    protected boolean isFieldSideEnabled() {
        return false;
    }

    protected int getFieldSideY() {
        return 34;
    }

    protected int getFieldUpdateIntervalY() {
        return 59;
    }

    protected int getFieldPriorityY() {
        return 84;
    }

    protected int getFieldChannelY() {
        return 109;
    }

    protected void onSave() {
        super.onSave();
        try {
            Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : (Direction)this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
            int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getTargetSideOverrideValueId(this.selectedIngredientComponent), (int)side);
            int channelInterface = this.numberFieldChannelInterfaceCrafting.getInt();
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.func_212873_a_()), (int)((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getLastChannelInterfaceCraftingValueId(), (int)channelInterface);
            ((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).setLastDisableCraftingCheckValue(this.checkboxFieldDisabledCraftingCheck.isChecked());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.ingredientComponentSideSelector = new WidgetArrowedListField<IngredientComponent<?, ?>>(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + 9, 68, 15, true, (ITextComponent)new TranslationTextComponent("gui.integratedcrafting.partsettings.ingredient"), true, Lists.newArrayList((Iterable)IngredientComponent.REGISTRY.getValues())){

            protected String activeElementToString(IngredientComponent<?, ?> element) {
                return L10NHelpers.localize((String)element.getTranslationKey(), (Object[])new Object[0]);
            }
        };
        this.ingredientComponentSideSelector.setListener((IInputListener)this);
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new ContainerScreenPartSettings.SideDropdownEntry((ContainerScreenPartSettings)this, x$0)).collect(Collectors.toList());
        this.dropdownFieldSide = new WidgetTextFieldDropdown(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + 34, 68, 14, (ITextComponent)new TranslationTextComponent("gui.integrateddynamics.partsettings.side"), true, (Set)Sets.newHashSet(this.dropdownEntries));
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.field_147002_h).getTargetSideOverrideValue(this.selectedIngredientComponent));
        this.dropdownFieldSide.func_146203_f(15);
        this.dropdownFieldSide.func_146189_e(true);
        this.dropdownFieldSide.func_146193_g(0xFFFFFF);
        this.dropdownFieldSide.func_146205_d(true);
        this.numberFieldChannelInterfaceCrafting = new WidgetNumberField(this.field_230712_o_, this.field_147003_i + 106, this.field_147009_r + 134, 70, 14, true, (ITextComponent)new TranslationTextComponent("gui.integratedcrafting.partsettings.channel.interface"), true);
        this.numberFieldChannelInterfaceCrafting.setPositiveOnly(false);
        this.numberFieldChannelInterfaceCrafting.func_146203_f(15);
        this.numberFieldChannelInterfaceCrafting.func_146189_e(true);
        this.numberFieldChannelInterfaceCrafting.func_146193_g(0xFFFFFF);
        this.numberFieldChannelInterfaceCrafting.func_146205_d(true);
        this.checkboxFieldDisabledCraftingCheck = new ButtonCheckbox(this.field_147003_i + 110, this.field_147009_r + 159, 110, 10, (ITextComponent)new TranslationTextComponent("gui.integratedcrafting.partsettings.craftingcheckdisabled"), entry -> {});
        this.refreshValues();
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (!this.numberFieldChannelInterfaceCrafting.func_231042_a_(typedChar, keyCode) && !this.dropdownFieldSide.func_231042_a_(typedChar, keyCode)) {
            return super.func_231042_a_(typedChar, keyCode);
        }
        return true;
    }

    public boolean func_231046_a_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.numberFieldChannelInterfaceCrafting.func_231046_a_(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.dropdownFieldSide.func_231046_a_(typedChar, keyCode, modifiers)) {
                return true;
            }
        }
        return super.func_231046_a_(typedChar, keyCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.ingredientComponentSideSelector.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.dropdownFieldSide.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.numberFieldChannelInterfaceCrafting.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.checkboxFieldDisabledCraftingCheck.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + 12), Helpers.RGBToInt((int)0, (int)0, (int)0));
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ingredientComponentSideSelector.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.dropdownFieldSide.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.channel.interface", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + 137), 0);
        this.numberFieldChannelInterfaceCrafting.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_238421_b_(matrixStack, L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.craftingcheckdisabled", (Object[])new Object[0]), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + 162), 0);
        this.checkboxFieldDisabledCraftingCheck.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected int getBaseYSize() {
        return 256;
    }

    protected void setSideInDropdownField(IngredientComponent<?, ?> ingredientComponent, Direction side) {
        if (this.selectedIngredientComponent == ingredientComponent) {
            this.dropdownFieldSide.selectPossibility((IDropdownEntry)this.dropdownEntries.get(side.ordinal()));
        }
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        super.onUpdate(valueId, value);
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValues()) {
            if (valueId != ((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getTargetSideOverrideValueId(ingredientComponent)) continue;
            int side = ((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getTargetSideOverrideValue(ingredientComponent).ordinal();
            this.setSideInDropdownField(ingredientComponent, side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getLastChannelInterfaceCraftingValueId()) {
            this.numberFieldChannelInterfaceCrafting.func_146180_a(Integer.toString(((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getLastChannelInterfaceValue()));
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getLastDisableCraftingCheckValueId()) {
            this.checkboxFieldDisabledCraftingCheck.setChecked(((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getLastDisableCraftingCheckValue());
        }
    }

    public void onChanged() {
        this.onSave();
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.func_212873_a_()).getTargetSideOverrideValue(this.selectedIngredientComponent));
    }
}

