/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LogicTileEntity
extends GenericTileEntity {
    protected int powerOutput = 0;

    public LogicTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public LogicFacing getFacing(BlockState state) {
        return (LogicFacing)((Object)state.func_177229_b(LogicSlabBlock.LOGIC_FACING));
    }

    public int getPowerOutput() {
        return this.powerOutput;
    }

    protected void setRedstoneState(int newout) {
        if (this.powerOutput == newout) {
            return;
        }
        this.powerOutput = newout;
        this.func_70296_d();
        BlockState state = this.func_195044_w();
        Direction outputSide = this.getFacing(state).getInputSide().func_176734_d();
        this.func_145831_w().func_190524_a(this.field_174879_c.func_177972_a(outputSide), state.func_177230_c(), this.field_174879_c);
    }

    @Override
    public void checkRedstone(World world, BlockPos pos) {
        Direction inputSide = this.getFacing(world.func_180495_p(pos)).getInputSide();
        int power = this.getInputStrength(world, pos, inputSide);
        this.setPowerInput(power);
    }

    public int getInputStrength(World world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power < 15 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = Math.max(power, (Integer)blockState.func_177229_b((Property)RedstoneWireBlock.field_176351_O));
        }
        return power;
    }

    @Override
    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (side == this.getFacing(state).getInputSide()) {
            return this.getPowerOutput();
        }
        return 0;
    }
}

