/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendResultToClient {
    private final BlockPos pos;
    private final List list;
    private final String command;

    public PacketSendResultToClient(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        CommandInfo info = McJtyLib.getCommandInfo(this.command);
        if (info == null) {
            throw new IllegalStateException("Command '" + this.command + "' is not registered!");
        }
        Function<PacketBuffer, PacketBuffer> deserializer = info.getDeserializer();
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(deserializer.apply(buf));
            }
        } else {
            this.list = null;
        }
    }

    public PacketSendResultToClient(BlockPos pos, String command, List list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList(list);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        CommandInfo info = McJtyLib.getCommandInfo(this.command);
        if (info == null) {
            throw new IllegalStateException("Command '" + this.command + "' is not registered!");
        }
        BiConsumer<PacketBuffer, PacketBuffer> serializer = info.getSerializer();
        if (serializer == null) {
            throw new IllegalStateException("Command '" + this.command + "' is not registered!");
        }
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (Object item : this.list) {
                serializer.accept(buf, (PacketBuffer)item);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).handleListFromServer(this.command, McJtyLib.proxy.getClientPlayer(), TypedMap.EMPTY, this.list);
            } else {
                Logging.logError("Can't handle command '" + this.command + "'!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

