/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.network.PacketSendResultToClient;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetListFromServer {
    protected final RegistryKey<World> dimension;
    protected final BlockPos pos;
    protected final String command;
    protected final TypedMap params;

    public PacketGetListFromServer(PacketBuffer buf) {
        this.dimension = LevelTools.getId(buf.func_192575_l());
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.dimension.func_240901_a_());
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        TypedMapTools.writeArguments(buf, this.params);
    }

    public PacketGetListFromServer(RegistryKey<World> dimension, BlockPos pos, String cmd, @Nonnull TypedMap params) {
        this.dimension = dimension;
        this.pos = pos;
        this.command = cmd;
        this.params = params;
    }

    public PacketGetListFromServer(BlockPos pos, String cmd, @Nonnull TypedMap params) {
        this.dimension = McJtyLib.proxy.getWorld().func_234923_W_();
        this.pos = pos;
        this.command = cmd;
        this.params = params;
    }

    public PacketGetListFromServer(BlockPos pos, String cmd) {
        this.dimension = McJtyLib.proxy.getWorld().func_234923_W_();
        this.pos = pos;
        this.command = cmd;
        this.params = TypedMap.EMPTY;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            ServerWorld world = LevelTools.getLevel(ctx.getSender().func_130014_f_(), this.dimension);
            if (world.func_175667_e(this.pos)) {
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof GenericTileEntity) {
                    CommandInfo info = McJtyLib.getCommandInfo(this.command);
                    if (info == null) {
                        throw new IllegalStateException("Command '" + this.command + "' is not registered!");
                    }
                    Class type = info.getType();
                    List list = ((GenericTileEntity)te).executeServerCommandList(this.command, (PlayerEntity)player, this.params, type);
                    McJtyLib.networkHandler.sendTo((Object)new PacketSendResultToClient(this.pos, this.command, list), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                } else {
                    Logging.logError("Command '" + this.command + "' not handled!");
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

