/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.widgets.Widget;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseDragged(GuiScreenEvent.MouseDragEvent.Pre event) {
        WindowManager manager;
        IKeyReceiver container;
        if (event.getGui() instanceof IKeyReceiver && (container = (IKeyReceiver)event.getGui()).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent()) {
            manager.mouseDragged(event.getMouseX(), event.getMouseY(), event.getMouseButton());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseScolled(GuiScreenEvent.MouseScrollEvent.Pre event) {
        WindowManager manager;
        IKeyReceiver container;
        if (event.getGui() instanceof IKeyReceiver && (container = (IKeyReceiver)event.getGui()).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent() && container.mouseScrolledFromEvent(event.getMouseX(), event.getMouseY(), event.getScrollDelta())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseClicked(GuiScreenEvent.MouseClickedEvent event) {
        WindowManager manager;
        IKeyReceiver container;
        if (event.getGui() instanceof IKeyReceiver && (container = (IKeyReceiver)event.getGui()).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent() && container.mouseClickedFromEvent(event.getMouseX(), event.getMouseY(), event.getButton())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseReleased(GuiScreenEvent.MouseReleasedEvent event) {
        WindowManager manager;
        IKeyReceiver container;
        if (event.getGui() instanceof IKeyReceiver && (container = (IKeyReceiver)event.getGui()).getWindow() != null && (manager = container.getWindow().getWindowManager()) != null && manager.getModalWindows().findFirst().isPresent() && container.mouseReleasedFromEvent(event.getMouseX(), event.getMouseY(), event.getButton())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiInput(GuiScreenEvent.KeyboardCharTypedEvent event) {
        Widget<?> focus;
        IKeyReceiver container;
        if (event.getGui() instanceof IKeyReceiver && (container = (IKeyReceiver)event.getGui()).getWindow() != null && (focus = container.getWindow().getWindowManager() == null ? container.getWindow().getTextFocus() : container.getWindow().getWindowManager().getTextFocus()) != null) {
            event.setCanceled(true);
            container.charTypedFromEvent(event.getCodePoint());
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(GuiScreenEvent.KeyboardKeyPressedEvent event) {
        Widget<?> focus;
        IKeyReceiver container;
        if (event.getGui() instanceof IKeyReceiver && (container = (IKeyReceiver)event.getGui()).getWindow() != null && (focus = container.getWindow().getWindowManager() == null ? container.getWindow().getTextFocus() : container.getWindow().getWindowManager().getTextFocus()) != null) {
            event.setCanceled(true);
            container.keyTypedFromEvent(event.getKeyCode(), event.getScanCode());
        }
    }
}

