/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.item.EnergyContainerItemAugmentable;
import cofh.core.util.ProxyUtils;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterRegistry;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.RayTracer;
import cofh.lib.util.Utils;
import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterableItem;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class RFMagnetItem
extends EnergyContainerItemAugmentable
implements IFilterableItem,
IMultiModeItem {
    protected static final int MAP_CAPACITY = 128;
    protected static final WeakHashMap<ItemStack, IFilter> FILTERS = new WeakHashMap(128);
    protected static final int RADIUS = 4;
    protected static final int REACH = 64;
    protected static final int TIME_CONSTANT = 8;
    protected static final int PICKUP_DELAY = 32;
    protected static final int ENERGY_PER_ITEM = 25;
    protected static final int ENERGY_PER_USE = 200;

    public RFMagnetItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 && this.getMode(stack) > 0 ? 1.0f : 0.0f);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Area", "Filter"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.magnet.use").func_240699_a_(TextFormatting.GRAY));
        if (FilterHelper.hasFilter((ItemStack)stack)) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.magnet.use.sneak").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.magnet.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return this.useDelegate(stack, context.func_195999_j(), context.func_221531_n()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.func_82737_E() % 8L != 0L) {
            return;
        }
        if (Utils.isClientWorld((World)worldIn) || Utils.isFakePlayer((Entity)entityIn) || this.getMode(stack) <= 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (this.getEnergyStored(stack) < 25 && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        int radius = this.getRadius(stack);
        int radSq = radius * radius;
        AxisAlignedBB area = new AxisAlignedBB(player.func_233580_cy_().func_177982_a(-radius, -radius, -radius), player.func_233580_cy_().func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List items = worldIn.func_175647_a(ItemEntity.class, area, EntityPredicates.field_94557_a);
        if (Utils.isClientWorld((World)worldIn)) {
            for (ItemEntity item : items) {
                if (item.func_174874_s() || item.getPersistentData().func_74767_n("PreventRemoteMovement") || !(item.func_213303_ch().func_72436_e(player.func_213303_ch()) <= (double)radSq)) continue;
                worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        } else {
            Predicate filterRules = this.getFilter(stack).getItemRules();
            int itemCount = 0;
            for (ItemEntity item : items) {
                if (item.func_174874_s() || item.getPersistentData().func_74767_n("PreventRemoteMovement") || !filterRules.test(item.func_92059_d()) || item.func_200214_m() != null && item.func_200214_m().equals(player.func_110124_au()) && item.field_70292_b < 32 || !(item.func_213303_ch().func_72436_e(player.func_213303_ch()) <= (double)radSq)) continue;
                item.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                item.func_174867_a(0);
                ++itemCount;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.extractEnergy(stack, 25 * itemCount, false);
            }
        }
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player, Hand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.func_226563_dT_()) {
            if (player instanceof ServerPlayerEntity && FilterHelper.hasFilter((ItemStack)stack)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getFilter(stack));
                return true;
            }
            return false;
        }
        if (this.getEnergyStored(stack) >= 200 || player.field_71075_bZ.field_75098_d) {
            BlockRayTraceResult traceResult = RayTracer.retrace((PlayerEntity)player, (double)64.0);
            if (traceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return false;
            }
            int radius = this.getRadius(stack);
            int radSq = radius * radius;
            World world = player.func_130014_f_();
            BlockPos pos = traceResult.func_216350_a();
            AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
            List items = world.func_175647_a(ItemEntity.class, area, EntityPredicates.field_94557_a);
            if (Utils.isClientWorld((World)world)) {
                for (ItemEntity item : items) {
                    if (!(item.func_213303_ch().func_72436_e(traceResult.func_216347_e()) <= (double)radSq)) continue;
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            } else {
                Predicate filterRules = this.getFilter(stack).getItemRules();
                int itemCount = 0;
                for (ItemEntity item : items) {
                    if (item.func_174874_s() || item.getPersistentData().func_74767_n("PreventRemoteMovement") || !filterRules.test(item.func_92059_d()) || !(item.func_213303_ch().func_72436_e(traceResult.func_216347_e()) <= (double)radSq)) continue;
                    item.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                    item.func_174867_a(0);
                    ++itemCount;
                }
                if (!player.field_71075_bZ.field_75098_d && itemCount > 0) {
                    this.extractEnergy(stack, 200 + 25 * itemCount, false);
                }
            }
            player.func_184609_a(hand);
            stack.func_190915_d(5);
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), TCoreSounds.SOUND_MAGNET, SoundCategory.PLAYERS, 0.4f, 1.0f);
        }
        return true;
    }

    protected int getRadius(ItemStack stack) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)1.0f);
        return Math.round(4.0f + mod * base);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"Radius");
        AugmentableHelper.setAttributeFromAugmentString((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"FilterType");
        super.setAttributesFromAugment(container, augmentData);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (!FilterHelper.hasFilter((ItemStack)container)) {
            container.func_196082_o().func_82580_o("Filter");
        }
        FILTERS.remove(container);
    }

    public IFilter getFilter(ItemStack stack) {
        String filterType = FilterHelper.getFilterType((ItemStack)stack);
        if (filterType.isEmpty()) {
            return EmptyFilter.INSTANCE;
        }
        IFilter ret = FILTERS.get(stack);
        if (ret != null) {
            return ret;
        }
        if (FILTERS.size() > 128) {
            FILTERS.clear();
        }
        FILTERS.put(stack, FilterRegistry.getHeldFilter((String)filterType, (CompoundNBT)stack.func_77978_p()));
        return FILTERS.get(stack);
    }

    public void onFilterChanged(ItemStack stack) {
        FILTERS.remove(stack);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), TCoreSounds.SOUND_MAGNET, SoundCategory.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.magnet.mode." + this.getMode(stack)));
    }
}

