/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.item.FluidContainerItemAugmentable;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryAmmoItem;
import cofh.lib.fluid.FluidContainerItemWrapper;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PotionQuiverItem
extends FluidContainerItemAugmentable
implements IMultiModeItem {
    protected static final int MB_PER_USE = 50;
    protected int arrowCapacity;

    public PotionQuiverItem(Item.Properties builder, int fluidCapacity, int arrowCapacity) {
        this(builder, fluidCapacity, arrowCapacity, FluidHelper::hasPotionTag);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("arrows"), (stack, world, entity) -> (float)this.getStoredArrows(stack) / (float)this.getMaxArrows(stack));
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity) -> this.getFluidAmount(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("active"), (stack, world, entity) -> this.getFluidAmount(stack) > 0 && this.getMode(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Potion", "Filter"});
    }

    public PotionQuiverItem(Item.Properties builder, int fluidCapacity, int arrowCapacity, Predicate<FluidStack> validator) {
        super(builder, fluidCapacity, validator);
        this.arrowCapacity = arrowCapacity;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.quiver.use").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.quiver.use.sneak").func_240699_a_(TextFormatting.DARK_GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.quiver.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.arrows") + ": " + (this.isCreative(stack, ContainerType.ITEM) ? StringHelper.localize((String)"info.cofh.infinite") : this.getStoredArrows(stack) + " / " + StringHelper.format((long)this.getMaxArrows(stack))))));
        FluidStack fluid = this.getFluid(stack);
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (EffectInstance effect : PotionUtils.func_185185_a((CompoundNBT)fluid.getTag())) {
            effects.add(new EffectInstance(effect.func_188419_a(), this.getEffectDuration(effect, stack), this.getEffectAmplifier(effect, stack), effect.func_82720_e(), effect.func_188418_e()));
        }
        this.potionTooltip(stack, worldIn, tooltip, flagIn, effects, 0.125f);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (this.getFluidAmount(stack) <= 0) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return this.getFluid(stack).getFluid().getAttributes().getColor(this.getFluid(stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Arrows", "Fluid"}));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return this.useDelegate(stack, context.func_195999_j(), context.func_221531_n()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"PotionAmp");
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"PotionDur");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player, Hand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.func_226563_dT_()) {
            ItemStack arrows = ArcheryHelper.findArrows((PlayerEntity)player);
            if (!arrows.func_190926_b() && arrows.func_190916_E() < arrows.func_77976_d()) {
                arrows.func_190917_f(this.removeArrows(stack, arrows.func_77976_d() - arrows.func_190916_E(), false));
            } else {
                arrows = new ItemStack((IItemProvider)Items.field_151032_g, Math.min(this.getStoredArrows(stack), 64));
                if (Utils.addToPlayerInventory((PlayerEntity)player, (ItemStack)arrows)) {
                    this.removeArrows(stack, arrows.func_190916_E(), false);
                }
            }
        } else if (player.field_71075_bZ.field_75098_d) {
            this.putArrows(stack, this.getMaxArrows(stack), false);
        } else {
            ItemStack arrows = ArcheryHelper.findArrows((PlayerEntity)player);
            arrows.func_190918_g(this.putArrows(stack, arrows.func_190916_E(), false));
        }
        stack.func_190915_d(5);
        return true;
    }

    protected int getStoredArrows(ItemStack stack) {
        return this.isCreative(stack, ContainerType.ITEM) ? this.getMaxArrows(stack) : stack.func_196082_o().func_74762_e("Arrows");
    }

    protected int getMaxArrows(ItemStack stack) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
        return this.getMaxStored(stack, Math.round((float)this.arrowCapacity * base));
    }

    protected int putArrows(ItemStack stack, int maxArrows, boolean simulate) {
        int stored = this.getStoredArrows(stack);
        int toAdd = Math.min(maxArrows, this.getMaxArrows(stack) - stored);
        if (!simulate && !this.isCreative(stack, ContainerType.ITEM)) {
            stack.func_196082_o().func_74768_a("Arrows", stored += toAdd);
        }
        return toAdd;
    }

    protected int removeArrows(ItemStack stack, int maxArrows, boolean simulate) {
        if (this.isCreative(stack, ContainerType.ITEM)) {
            return maxArrows;
        }
        int stored = Math.min(stack.func_196082_o().func_74762_e("Arrows"), this.getMaxArrows(stack));
        int toRemove = Math.min(maxArrows, stored);
        if (!simulate) {
            stack.func_196082_o().func_74768_a("Arrows", stored -= toRemove);
        }
        return toRemove;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PotionQuiverItemWrapper(stack, (IFluidContainerItem)this);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        int arrowExcess = this.getStoredArrows(container) - this.getMaxArrows(container);
        if (arrowExcess > 0) {
            this.removeArrows(container, arrowExcess, false);
        }
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.quiver.mode." + this.getMode(stack)));
    }

    protected class PotionQuiverItemWrapper
    extends FluidContainerItemWrapper
    implements IArcheryAmmoItem {
        private final LazyOptional<IArcheryAmmoItem> holder;

        PotionQuiverItemWrapper(ItemStack containerIn, IFluidContainerItem itemIn) {
            super(containerIn, itemIn);
            this.holder = LazyOptional.of(() -> this);
        }

        public void onArrowLoosed(PlayerEntity shooter) {
            if (shooter != null && !shooter.field_71075_bZ.field_75098_d) {
                PotionQuiverItem.this.removeArrows(this.container, 1, false);
                this.drain(50, PotionQuiverItem.this.getMode(this.container) == 1 ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
            }
        }

        public AbstractArrowEntity createArrowEntity(World world, PlayerEntity shooter) {
            FluidStack fluid = PotionQuiverItem.this.getFluid(this.container);
            if (PotionQuiverItem.this.getMode(this.container) == 1 && fluid != null && fluid.getAmount() >= 50) {
                ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
                for (EffectInstance effect : PotionUtils.func_185185_a((CompoundNBT)fluid.getTag())) {
                    effects.add(new EffectInstance(effect.func_188419_a(), PotionQuiverItem.this.getEffectDuration(effect, this.container), PotionQuiverItem.this.getEffectAmplifier(effect, this.container), effect.func_82720_e(), effect.func_188418_e()));
                }
                ItemStack arrowStack = PotionUtils.func_185184_a((ItemStack)new ItemStack((IItemProvider)Items.field_185167_i), effects);
                return ((TippedArrowItem)arrowStack.func_77973_b()).func_200887_a(world, arrowStack, (LivingEntity)shooter);
            }
            ItemStack arrowStack = new ItemStack((IItemProvider)Items.field_151032_g);
            return ((ArrowItem)arrowStack.func_77973_b()).func_200887_a(world, arrowStack, (LivingEntity)shooter);
        }

        public boolean isEmpty(PlayerEntity shooter) {
            if (PotionQuiverItem.this.isCreative(this.container, ContainerType.ITEM) || shooter != null && shooter.field_71075_bZ.field_75098_d) {
                return false;
            }
            return PotionQuiverItem.this.getStoredArrows(this.container) <= 0;
        }

        public boolean isInfinite(ItemStack bow, PlayerEntity shooter) {
            return shooter != null && shooter.field_71075_bZ.field_75098_d || Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityArchery.AMMO_ITEM_CAPABILITY) {
                return CapabilityArchery.AMMO_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

