/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.common.tiles;

import com.direwolf20.charginggadgets.common.Config;
import com.direwolf20.charginggadgets.common.blocks.ModBlocks;
import com.direwolf20.charginggadgets.common.capabilities.ChargerEnergyStorage;
import com.direwolf20.charginggadgets.common.capabilities.ChargerItemHandler;
import com.direwolf20.charginggadgets.common.container.ChargingStationContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ChargingStationTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private int counter = 0;
    private int maxBurn = 0;
    public ChargerEnergyStorage energyStorage;
    private LazyOptional<ChargerEnergyStorage> energy;
    private LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ChargerItemHandler(this));
    public final IIntArray chargingStationData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ChargingStationTile.this.energyStorage.getEnergyStored() / 32;
                }
                case 1: {
                    return ChargingStationTile.this.energyStorage.getMaxEnergyStored() / 32;
                }
                case 2: {
                    return ChargingStationTile.this.counter;
                }
                case 3: {
                    return ChargingStationTile.this.maxBurn;
                }
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public void func_221477_a(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public ChargingStationTile() {
        super((TileEntityType)ModBlocks.CHARGING_STATION_TILE.get());
        this.energyStorage = new ChargerEnergyStorage(this, 0, (Integer)Config.GENERAL.chargerMaxPower.get());
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new ChargingStationContainer(this, this.chargingStationData, i, playerInventory, (ItemStackHandler)this.inventory.orElse((Object)new ItemStackHandler(2)));
    }

    public void func_73660_a() {
        if (this.func_145831_w() == null) {
            return;
        }
        this.inventory.ifPresent(handler -> {
            this.tryBurn();
            ItemStack stack = handler.getStackInSlot(Slots.CHARGE.id);
            if (!stack.func_190926_b()) {
                this.chargeItem(stack);
            }
        });
    }

    private void chargeItem(ItemStack stack) {
        this.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(itemEnergy -> {
            if (!this.isChargingItem((IEnergyStorage)itemEnergy)) {
                return;
            }
            int energyRemoved = itemEnergy.receiveEnergy(Math.min(energyStorage.getEnergyStored(), 2500), false);
            ((ChargerEnergyStorage)energyStorage).consumeEnergy(energyRemoved, false);
        }));
    }

    public boolean isChargingItem(IEnergyStorage energy) {
        return energy.getEnergyStored() >= 0 && energy.receiveEnergy(energy.getEnergyStored(), true) >= 0;
    }

    private void tryBurn() {
        if (this.field_145850_b == null) {
            return;
        }
        this.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
            boolean canInsertEnergy;
            boolean bl = canInsertEnergy = energyStorage.receiveEnergy(625, true) > 0;
            if (this.counter > 0 && canInsertEnergy) {
                this.burn((IEnergyStorage)energyStorage);
            } else if (canInsertEnergy && this.initBurn()) {
                this.burn((IEnergyStorage)energyStorage);
            }
        });
    }

    private void burn(IEnergyStorage energyStorage) {
        energyStorage.receiveEnergy(625, false);
        --this.counter;
        if (this.counter == 0) {
            this.maxBurn = 0;
            this.initBurn();
        }
    }

    private boolean initBurn() {
        ItemStackHandler handler = (ItemStackHandler)this.inventory.orElseThrow(RuntimeException::new);
        ItemStack stack = handler.getStackInSlot(Slots.FUEL.id);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack);
        if (burnTime > 0) {
            Item fuelStack = handler.getStackInSlot(Slots.FUEL.id).func_77973_b();
            handler.extractItem(0, 1, false);
            if (fuelStack instanceof BucketItem && fuelStack != Items.field_151133_ar) {
                handler.insertItem(0, new ItemStack((IItemProvider)Items.field_151133_ar, 1), false);
            }
            this.func_70296_d();
            this.maxBurn = this.counter = (int)Math.floor(burnTime) / 50;
            return true;
        }
        return false;
    }

    public void func_230337_a_(BlockState stateIn, CompoundNBT compound) {
        super.func_230337_a_(stateIn, compound);
        this.inventory.ifPresent(h -> h.deserializeNBT(compound.func_74775_l("inv")));
        this.energy.ifPresent(h -> h.deserializeNBT(compound.func_74775_l("energy")));
        this.counter = compound.func_74762_e("counter");
        this.maxBurn = compound.func_74762_e("maxburn");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.inventory.ifPresent(h -> compound.func_218657_a("inv", (INBT)h.serializeNBT()));
        this.energy.ifPresent(h -> compound.func_218657_a("energy", (INBT)h.serializeNBT()));
        compound.func_74768_a("counter", this.counter);
        compound.func_74768_a("maxburn", this.maxBurn);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState stateIn, CompoundNBT tag) {
        this.func_230337_a_(stateIn, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_145843_s() {
        this.energy.invalidate();
        this.inventory.invalidate();
        super.func_145843_s();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Charging Station Tile");
    }

    public static enum Slots {
        FUEL(0),
        CHARGE(1);

        int id;

        private Slots(int number) {
            this.id = number;
        }

        public int getId() {
            return this.id;
        }
    }
}

