/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import architectury_inject_FTBChunks1165_common_b841d28807b440dc860c77f931b15262.PlatformMethods;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksRenderTypes;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.MinimapRenderer;
import dev.ftb.mods.ftbchunks.client.RegionMapPanel;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.core.BiomeManagerFTBC;
import dev.ftb.mods.ftbchunks.core.ClientboundSectionBlocksUpdatePacketFTBC;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.event.events.client.ClientScreenInputEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.architectury.registry.ReloadListeners;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class FTBChunksClient
extends FTBChunksCommon {
    private static final ResourceLocation BUTTON_ID = new ResourceLocation("ftbchunks:open_gui");
    public static final ResourceLocation CIRCLE_MASK = new ResourceLocation("ftbchunks:textures/circle_mask.png");
    public static final ResourceLocation CIRCLE_BORDER = new ResourceLocation("ftbchunks:textures/circle_border.png");
    public static final ResourceLocation PLAYER = new ResourceLocation("ftbchunks:textures/player.png");
    public static final ResourceLocation[] COMPASS = new ResourceLocation[]{new ResourceLocation("ftbchunks:textures/compass_e.png"), new ResourceLocation("ftbchunks:textures/compass_n.png"), new ResourceLocation("ftbchunks:textures/compass_w.png"), new ResourceLocation("ftbchunks:textures/compass_s.png")};
    private static final List<ITextComponent> MINIMAP_TEXT_LIST = new ArrayList<ITextComponent>(3);
    private static final ArrayDeque<MapTask> taskQueue = new ArrayDeque();
    public static long taskQueueTicks = 0L;
    public static Map<ChunkPos, IntOpenHashSet> rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
    public static KeyBinding openMapKey;
    public static KeyBinding zoomInKey;
    public static KeyBinding zoomOutKey;
    public static int minimapTextureId;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private static int renderedDebugCount;
    public static boolean updateMinimap;
    public static boolean alwaysRenderChunksOnMap;
    public static SendGeneralDataPacket generalData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;

    public static void queue(MapTask task) {
        taskQueue.addLast(task);
    }

    @Override
    public void init() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        FTBChunksClientConfig.init();
        FTBChunksClient.registerKeys();
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new EntityIcons());
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        GuiEvent.RENDER_HUD.register(this::renderHud);
        GuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        FTBChunksClient.registerPlatform();
    }

    private static void registerKeys() {
        openMapKey = new KeyBinding("key.ftbchunks.map", InputMappings.Type.KEYSYM, 77, "key.categories.ui");
        KeyBindings.registerKeyBinding((KeyBinding)openMapKey);
        zoomInKey = new KeyBinding("key.ftbchunks.minimap.zoomIn", InputMappings.Type.KEYSYM, 61, "key.categories.ui");
        KeyBindings.registerKeyBinding((KeyBinding)zoomInKey);
        zoomOutKey = new KeyBinding("key.ftbchunks.minimap.zoomOut", InputMappings.Type.KEYSYM, 45, "key.categories.ui");
        KeyBindings.registerKeyBinding((KeyBinding)zoomOutKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        PlatformMethods.platform("registerPlatform");
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderMinimap(MapDimension dimension, MinimapRenderer renderer) {
        void var1_1;
        PlatformMethods.platform("renderMinimap", (MapDimension)dimension, (MinimapRenderer)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addWidgets(RegionMapPanel panel) {
        PlatformMethods.platform("addWidgets", (RegionMapPanel)panel);
    }

    public static void openGui() {
        new LargeMapScreen().openGui();
    }

    public static void saveAllRegions() {
        if (MapManager.inst == null) {
            return;
        }
        for (MapDimension dimension : MapManager.inst.getDimensions().values()) {
            for (MapRegion region : dimension.getLoadedRegions()) {
                if (!region.saveData) continue;
                FTBChunksClient.queue(region);
                region.saveData = false;
            }
            if (!dimension.saveData) continue;
            FTBChunksClient.queue(dimension);
            dimension.saveData = false;
        }
        if (MapManager.inst.saveData) {
            FTBChunksClient.queue(MapManager.inst);
            MapManager.inst.saveData = false;
        }
    }

    @Override
    public void login(LoginDataPacket loginData) {
        FTBChunksWorldConfig.CONFIG.read(loginData.config);
        Path dir = Platform.getGameFolder().resolve("local/ftbchunks/data/" + loginData.serverId);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        MapManager.inst = new MapManager(loginData.serverId, dir);
        updateMinimap = true;
        renderedDebugCount = 0;
        ChunkUpdateTask.debugLastTime = 0L;
    }

    public void loggedOut(@Nullable ClientPlayerEntity player) {
        MapManager manager = MapManager.inst;
        if (manager != null) {
            MapTask task;
            FTBChunksClient.saveAllRegions();
            while ((task = taskQueue.pollFirst()) != null) {
                try {
                    task.runMapTask();
                }
                catch (Exception ex) {
                    FTBChunks.LOGGER.error("Failed to run task " + task);
                    ex.printStackTrace();
                }
            }
            MapDimension.updateCurrent();
            manager.release();
        }
        MapManager.inst = null;
    }

    @Override
    public void updateGeneralData(SendGeneralDataPacket packet) {
        generalData = packet;
    }

    @Override
    public void updateChunk(SendChunkPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, packet.chunk, packet.teamId, now));
    }

    @Override
    public void updateAllChunks(SendManyChunksPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        for (SendChunkPacket.SingleChunk c : packet.chunks) {
            FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, c, packet.teamId, now));
        }
    }

    @Override
    public void updateVisiblePlayerList(SendVisiblePlayerListPacket packet) {
        PlayerLocation.CLIENT_LIST.clear();
        PlayerLocation.currentDimension = packet.dim;
        PlayerLocation.CLIENT_LIST.addAll(packet.players);
    }

    @Override
    public void syncRegion(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    @Override
    public void playerDeath(PlayerDeathPacket packet) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue()) {
            MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
            for (Waypoint w : dimension.getWaypoints()) {
                if (w.type != WaypointType.DEATH) continue;
                w.hidden = true;
                w.type = WaypointType.DEATH_OLD;
            }
            Waypoint w = new Waypoint(dimension);
            w.name = "Death #" + packet.number;
            w.x = packet.x;
            w.y = packet.y;
            w.z = packet.z;
            w.type = WaypointType.DEATH;
            w.color = 0xFF0000;
            dimension.getWaypoints().add(w);
            dimension.saveData = true;
        }
    }

    @Override
    public int blockColor() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_222817_e(() -> {
            if (mc.field_71476_x instanceof BlockRayTraceResult && mc.field_71474_y.field_74319_N) {
                ResourceLocation id = Registry.field_212618_g.func_177774_c((Object)mc.field_71441_e.func_180495_p(((BlockRayTraceResult)mc.field_71476_x).func_216350_a()).func_177230_c());
                NativeImage image = ScreenShotHelper.func_198052_a((int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (Framebuffer)mc.func_147110_a());
                int col = image.func_195709_a(image.func_195702_a() / 2, image.func_195714_b() / 2);
                String s = String.format("\"%s\": \"#%06X\"", id.func_110623_a(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(id.func_110624_b() + " - " + s).func_240703_c_(Style.field_240709_b_.func_240721_b_(TextFormatting.GOLD).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to copy")))), Util.field_240973_b_);
            } else {
                mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("You must be looking at a block in F1 mode!"), Util.field_240973_b_);
            }
        });
        return 1;
    }

    @Override
    public void updateLoadedChunkView(RegistryKey<World> dimension, Collection<ChunkPos> chunks) {
        MapDimension dim = MapManager.inst.getDimension(dimension);
        dim.loadedChunkView = chunks;
        MapManager.inst.updateAllRegions(false);
    }

    public ActionResultType customClick(CustomClickEvent event) {
        if (event.getId().equals((Object)BUTTON_ID)) {
            FTBChunksClient.openGui();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionResultType keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (openMapKey.func_151470_d()) {
            if (Screen.func_231172_r_()) {
                SNBTCompoundTag tag = new SNBTCompoundTag();
                tag.func_74757_a(FTBChunksClientConfig.MINIMAP_ENABLED.key, (Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false);
                FTBChunksClientConfig.MINIMAP_ENABLED.read(tag);
                FTBChunksClientConfig.saveConfig();
                return ActionResultType.PASS;
            }
            if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue() && Screen.func_231174_t_()) {
                FTBChunks.LOGGER.info("=== Task Queue: " + taskQueue.size());
                Iterator<MapTask> iterator = taskQueue.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        FTBChunks.LOGGER.info("===");
                        return ActionResultType.PASS;
                    }
                    MapTask task = iterator.next();
                    FTBChunks.LOGGER.info(task.toString());
                }
            }
            FTBChunksClient.openGui();
            return ActionResultType.SUCCESS;
        }
        if (zoomInKey.func_151470_d()) {
            return this.changeZoom(true);
        }
        if (!zoomOutKey.func_151470_d()) return ActionResultType.PASS;
        return this.changeZoom(false);
    }

    public ActionResultType keyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (openMapKey.func_151470_d() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null) {
            gui.closeGui(false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return ActionResultType.SUCCESS;
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = MathHelper.func_226163_a_((long)(System.currentTimeMillis() - this.lastZoomTime), (long)0L, (long)max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)MathHelper.func_219803_d((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public void renderHud(MatrixStack matrixStack, float tickDelta) {
        RegistryKey biome;
        ClientTeam team;
        MapRegionData data;
        double d;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null || MapManager.inst == null) {
            return;
        }
        MapDimension dim = MapDimension.getCurrent();
        if (dim.dimension != mc.field_71441_e.func_234923_W_()) {
            MapDimension.updateCurrent();
            dim = MapDimension.getCurrent();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        if (minimapTextureId == -1) {
            minimapTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225680_a_((int)minimapTextureId, (int)240, (int)240);
            updateMinimap = true;
        }
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)minimapTextureId);
        boolean minimapBlur = (Boolean)FTBChunksClientConfig.MINIMAP_BLUR.get();
        if (minimapBlur) {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        } else {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        }
        int cx = mc.field_71439_g.field_70176_ah;
        int cz = mc.field_71439_g.field_70164_aj;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            updateMinimap = true;
        }
        if (updateMinimap) {
            updateMinimap = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().func_227789_a_(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.field_71474_y.field_74330_P || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || ((Boolean)FTBChunksWorldConfig.FORCE_DISABLE_MINIMAP.get()).booleanValue()) {
            return;
        }
        float zoom = this.getZoom();
        float scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / mc.func_228018_at_().func_198100_s());
        float minimapRotation = ((Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false ? 180.0f : -mc.field_71439_g.field_70177_z) % 360.0f;
        int s = (int)(64.0 * (double)scale);
        int x = ((MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get())).getX(mc.func_228018_at_().func_198107_o(), s);
        int y = ((MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get())).getY(mc.func_228018_at_().func_198087_p(), s);
        boolean z = false;
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float f0 = 0.06666667f;
        float f1 = 1.0f - f0;
        float offX = (float)((mc.field_71439_g.func_226277_ct_() / 16.0 - (double)this.currentPlayerChunkX - 0.5) / 15.0);
        float offY = (float)((mc.field_71439_g.func_226281_cx_() / 16.0 - (double)this.currentPlayerChunkZ - 0.5) / 15.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x + (double)s / 2.0, (double)y + (double)s / 2.0, -10.0);
        matrixStack.func_227861_a_(0.0, 0.0, 500.0);
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        mc.func_110434_K().func_110577_a(CIRCLE_MASK);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        RenderSystem.bindTexture((int)minimapTextureId);
        matrixStack.func_227862_a_(zoom, zoom, 1.0f);
        m = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f0 + offX, f0 + offY).func_181675_d();
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f0 + offX, f1 + offY).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f1 + offX, f1 + offY).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f1 + offX, f0 + offY).func_181675_d();
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        m = matrixStack.func_227866_c_().func_227870_a_();
        mc.func_110434_K().func_110577_a(CIRCLE_BORDER);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)x, (float)(y + s), (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + s), (float)(y + s), (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + s), (float)y, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableTexture();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(m, (float)x + (float)s / 2.0f, (float)(y + 0), (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, (float)x + (float)s / 2.0f, (float)(y + s), (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + 0), (float)y + (float)s / 2.0f, (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + s), (float)y + (float)s / 2.0f, (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            for (int face = 0; face < 4; ++face) {
                double d2 = (double)s / 2.2;
                double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d2);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d2);
                float ws = (float)s / 32.0f;
                m = matrixStack.func_227866_c_().func_227870_a_();
                mc.func_110434_K().func_110577_a(COMPASS[face]);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        double magicNumber = 3.2;
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue() && !dim.getWaypoints().isEmpty()) {
            for (Waypoint waypoint : dim.getWaypoints()) {
                double distance;
                if (waypoint.hidden || (distance = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5))) > (double)waypoint.minimapDistance) continue;
                double d3 = distance / magicNumber * (double)scale * (double)zoom;
                if (d3 > (double)s / 2.0) {
                    d3 = (double)s / 2.0;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - (double)waypoint.z - 0.5, mc.field_71439_g.func_226277_ct_() - (double)waypoint.x - 0.5) + (double)minimapRotation * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d3);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d3);
                float ws = (float)s / 32.0f;
                int r = waypoint.color >> 16 & 0xFF;
                int g = waypoint.color >> 8 & 0xFF;
                int b = waypoint.color >> 0 & 0xFF;
                m = matrixStack.func_227866_c_().func_227870_a_();
                mc.func_110434_K().func_110577_a(waypoint.type.texture);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        FTBChunksClient.renderMinimap(dim, (px, pz, color, maxDistance) -> {
            double distance = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)((double)px + 0.5), (double)((double)pz + 0.5));
            double d = distance / magicNumber * (double)scale * (double)zoom;
            if (maxDistance > 0 && distance > (double)maxDistance) {
                return;
            }
            if (d > (double)s / 2.0) {
                if (maxDistance == 0) {
                    return;
                }
                d = (double)s / 2.0;
            }
            double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - (double)pz - 0.5, mc.field_71439_g.func_226277_ct_() - (double)px - 0.5) + (double)minimapRotation * Math.PI / 180.0;
            float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d);
            float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d);
            float ws = (float)s / 32.0f;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            mc.func_110434_K().func_110577_a(WaypointType.WAYSTONE.texture);
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            buffer.func_227888_a_(matrix, wx - ws, wy - ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(matrix, wx - ws, wy + ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, wx + ws, wy + ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, wx + ws, wy - ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        });
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (Entity entity : mc.field_71441_e.func_217416_b()) {
                ResourceLocation texture;
                if (entity instanceof AbstractClientPlayerEntity || entity.func_200600_R().func_220339_d() == EntityClassification.MISC || entity.func_226278_cu_() < (double)(entity.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)entity.func_226281_cx_())) - 10) || (d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)entity.func_226277_ct_(), (double)entity.func_226281_cx_()) / magicNumber * (double)scale * (double)zoom) > (double)s / 2.0 || (texture = EntityIcons.ENTITY_ICONS.get(entity.func_200600_R())) == EntityIcons.INVISIBLE) continue;
                if (texture == null || !((Boolean)FTBChunksClientConfig.MINIMAP_ENTITY_HEADS.get()).booleanValue()) {
                    texture = entity instanceof IMob ? EntityIcons.HOSTILE : EntityIcons.NORMAL;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - entity.func_226281_cx_(), mc.field_71439_g.func_226277_ct_() - entity.func_226277_ct_()) + (double)minimapRotation * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d);
                float ws = (float)s / ((Boolean)FTBChunksClientConfig.MINIMAP_LARGE_ENTITIES.get() != false ? 32.0f : 48.0f);
                m = matrixStack.func_227866_c_().func_227870_a_();
                mc.func_110434_K().func_110577_a(texture);
                RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
                RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue() && mc.field_71441_e.func_217369_A().size() > 1) {
            for (AbstractClientPlayerEntity player : mc.field_71441_e.func_217369_A()) {
                if (player == mc.field_71439_g || player.func_98034_c((PlayerEntity)mc.field_71439_g)) continue;
                d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)player.func_226277_ct_(), (double)player.func_226281_cx_()) / magicNumber * (double)scale * (double)zoom;
                if (d > (double)s / 2.0) {
                    d = (double)s / 2.0;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - player.func_226281_cx_(), mc.field_71439_g.func_226277_ct_() - player.func_226277_ct_()) + (double)minimapRotation * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d);
                float ws = (float)s / 32.0f;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)wx, (double)wy, (double)z);
                matrixStack.func_227862_a_(ws, ws, 1.0f);
                FaceIcon.getFace((GameProfile)player.func_146103_bH()).draw(matrixStack, -1, -1, 2, 2);
                matrixStack.func_227865_b_();
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get()).booleanValue()) {
            mc.func_110434_K().func_110577_a(PLAYER);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + (double)s / 2.0, (double)y + (double)s / 2.0, (double)z);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(mc.field_71439_g.field_70177_z + 180.0f));
            matrixStack.func_227862_a_((float)s / 16.0f, (float)s / 16.0f, 1.0f);
            m = matrixStack.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            buffer.func_227888_a_(m, -1.0f, -1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(0.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(m, -1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(m, 1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(m, 1.0f, -1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            matrixStack.func_227865_b_();
        }
        MINIMAP_TEXT_LIST.clear();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ZONE.get()).booleanValue() && (data = dim.getRegion(XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getData()) != null && (team = data.getChunk(XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ)).getTeam()) != null) {
            MINIMAP_TEXT_LIST.add(team.getColoredName());
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_XYZ.get()).booleanValue()) {
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(MathHelper.func_76128_c((double)mc.field_71439_g.func_226277_ct_()) + " " + MathHelper.func_76128_c((double)mc.field_71439_g.func_226278_cu_()) + " " + MathHelper.func_76128_c((double)mc.field_71439_g.func_226281_cx_())));
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_BIOME.get()).booleanValue() && (biome = (RegistryKey)mc.field_71441_e.func_242406_i(mc.field_71439_g.func_233580_cy_()).orElse(null)) != null) {
            MINIMAP_TEXT_LIST.add((ITextComponent)new TranslationTextComponent("biome." + biome.func_240901_a_().func_110624_b() + "." + biome.func_240901_a_().func_110623_a()));
        }
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            XZ r = XZ.regionFromChunk((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ);
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent("Queued tasks: " + taskQueue.size()));
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(r.toRegionString()));
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent("Total updates: " + renderedDebugCount));
            if (ChunkUpdateTask.debugLastTime > 0L) {
                MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(String.format("LU: %,d ns", ChunkUpdateTask.debugLastTime)));
            }
        }
        if (!MINIMAP_TEXT_LIST.isEmpty()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + (double)s / 2.0, (double)(y + s) + 3.0, 0.0);
            matrixStack.func_227862_a_((float)(0.5 * (double)scale), (float)(0.5 * (double)scale), 1.0f);
            for (int i = 0; i < MINIMAP_TEXT_LIST.size(); ++i) {
                IReorderingProcessor bs = MINIMAP_TEXT_LIST.get(i).func_241878_f();
                int bsw = mc.field_71466_p.func_243245_a(bs);
                mc.field_71466_p.func_238407_a_(matrixStack, bs, (float)(-bsw) / 2.0f, (float)(i * 11), -1);
            }
            matrixStack.func_227865_b_();
        }
        RenderSystem.enableDepthTest();
    }

    public void renderWorldLast(MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N || !((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue() || MapManager.inst == null || mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        MapDimension dim = MapDimension.getCurrent();
        if (dim.getWaypoints().isEmpty()) {
            return;
        }
        ArrayList<Waypoint> visibleWaypoints = new ArrayList<Waypoint>();
        for (Waypoint waypoint : dim.getWaypoints()) {
            if (waypoint.hidden) continue;
            waypoint.distance = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5));
            if (waypoint.distance <= 8.0 || waypoint.distance > (double)waypoint.inWorldDistance) continue;
            waypoint.alpha = 150;
            if (waypoint.distance < 12.0) {
                waypoint.alpha = (int)((double)waypoint.alpha * ((waypoint.distance - 8.0) / 4.0));
            }
            if (waypoint.alpha <= 0) continue;
            visibleWaypoints.add(waypoint);
        }
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        if (visibleWaypoints.size() >= 2) {
            visibleWaypoints.sort(Comparator.comparingDouble(value -> -value.distance));
        }
        ActiveRenderInfo camera = Minecraft.func_71410_x().func_175598_ae().field_217783_c;
        Vector3d cameraPos = camera.func_216785_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-cameraPos.field_72450_a, -cameraPos.field_72448_b, -cameraPos.field_72449_c);
        IVertexBuilder depthBuffer = mc.func_228019_au_().func_228487_b_().getBuffer(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        float h = (float)(cameraPos.field_72448_b + 30.0);
        float h2 = h + 70.0f;
        for (Waypoint waypoint : visibleWaypoints) {
            double angle = Math.atan2(cameraPos.field_72449_c - (double)waypoint.z - 0.5, cameraPos.field_72450_a - (double)waypoint.x - 0.5) * 180.0 / Math.PI;
            int r = waypoint.color >> 16 & 0xFF;
            int g = waypoint.color >> 8 & 0xFF;
            int b = waypoint.color >> 0 & 0xFF;
            ms.func_227860_a_();
            ms.func_227861_a_((double)waypoint.x + 0.5, 0.0, (double)waypoint.z + 0.5);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-angle - 135.0)));
            float s = 0.6f;
            Matrix4f m = ms.func_227866_c_().func_227870_a_();
            depthBuffer.func_227888_a_(m, -s, 0.0f, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, 0.0f, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h2, s).func_225586_a_(r, g, b, 0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h2, -s).func_225586_a_(r, g, b, 0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
        mc.func_228019_au_().func_228487_b_().func_228462_a_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
    }

    public ActionResultType screenOpened(Screen screen, List<Widget> widgets, List<IGuiEventListener> children) {
        if (screen instanceof IngameMenuScreen) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        return ActionResultType.PASS;
    }

    public void clientTick(Minecraft client) {
        MapManager manager = MapManager.inst;
        if (manager != null && Minecraft.func_71410_x().field_71441_e != null) {
            int s;
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L && !rerenderCache.isEmpty()) {
                ClientWorld level = Minecraft.func_71410_x().field_71441_e;
                long biomeZoomSeed = ((BiomeManagerFTBC)level.func_225523_d_()).getBiomeZoomSeedFTBC();
                for (Map.Entry<ChunkPos, IntOpenHashSet> pos : rerenderCache.entrySet()) {
                    IChunk chunkAccess = level.func_217353_a(pos.getKey().field_77276_a, pos.getKey().field_77275_b, ChunkStatus.field_222617_m, false);
                    if (chunkAccess == null) continue;
                    FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (World)level, chunkAccess, pos.getKey(), chunkAccess.func_225549_i_(), biomeZoomSeed, pos.getValue().toIntArray()));
                }
                rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
            }
            if (taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L && (s = Math.min(taskQueue.size(), (Integer)FTBChunksClientConfig.TASK_QUEUE_MAX.get())) > 0) {
                MapTask[] tasks = new MapTask[s];
                for (int i = 0; i < s; ++i) {
                    tasks[i] = taskQueue.pollFirst();
                    if (tasks[i] == null || tasks[i].cancelOtherTasks()) break;
                }
                for (MapTask task : tasks) {
                    if (task == null) continue;
                    try {
                        task.runMapTask();
                    }
                    catch (Exception ex) {
                        FTBChunks.LOGGER.error("Failed to run task " + task);
                        ex.printStackTrace();
                    }
                }
            }
            ++taskQueueTicks;
        }
    }

    public void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    public static void rerender(BlockPos pos, BlockState state) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IntOpenHashSet set = rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.func_177958_n() & 0xF) + (pos.func_177952_p() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++renderedDebugCount;
        }
    }

    public static void handlePacket(ClientboundSectionBlocksUpdatePacketFTBC p) {
        SectionPos sectionPos = p.getSectionPosFTBC();
        short[] positions = p.getPositionsFTBC();
        BlockState[] states = p.getStatesFTBC();
        for (int i = 0; i < positions.length; ++i) {
            FTBChunksClient.rerender(sectionPos.func_243647_g(positions[i]), states[i]);
        }
    }

    public static void handlePacket(SChunkDataPacket p) {
        IChunk chunkAccess;
        MapManager manager = MapManager.inst;
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level != null && p.func_149274_i() && (chunkAccess = level.func_217353_a(p.func_149273_e(), p.func_149271_f(), ChunkStatus.field_222617_m, false)) != null) {
            long biomeZoomSeed = ((BiomeManagerFTBC)level.func_225523_d_()).getBiomeZoomSeedFTBC();
            BiomeContainer biomeContainer = p.func_244296_i() == null ? null : new BiomeContainer((IObjectIntIterable)level.func_241828_r().func_243612_b(Registry.field_239720_u_), p.func_244296_i());
            FTBChunksClient.queueOrExecute(new ChunkUpdateTask(manager, (World)level, chunkAccess, new ChunkPos(p.func_149273_e(), p.func_149271_f()), biomeContainer, biomeZoomSeed, ChunkUpdateTask.ALL_BLOCKS));
        }
    }

    public static void queueOrExecute(MapTask task) {
        FTBChunks.EXECUTOR.execute(task);
    }

    public static void handlePacket(SChangeBlockPacket p) {
        FTBChunksClient.rerender(p.func_179827_b(), p.func_197685_a());
    }

    static {
        minimapTextureId = -1;
        renderedDebugCount = 0;
        updateMinimap = false;
        alwaysRenderChunksOnMap = false;
    }
}

