/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import malte0811.recipebuffers.util.ListSerializer;
import net.minecraft.network.PacketBuffer;

public abstract class RecurringData<T> {
    protected final PacketBuffer io;
    protected int hits = 0;

    protected RecurringData(PacketBuffer io) {
        this.io = io;
    }

    public static <T> RecurringData<T> reader(PacketBuffer buffer, Function<PacketBuffer, T> read) {
        return new Reader<T>(buffer, read);
    }

    public static <T> RecurringData<T> writer(PacketBuffer buffer, BiConsumer<PacketBuffer, T> write) {
        return new Writer<T>(buffer, write);
    }

    public static <T> RecurringData<T> create(PacketBuffer buffer, Function<PacketBuffer, T> read, BiConsumer<PacketBuffer, T> write, boolean reader) {
        if (reader) {
            return RecurringData.reader(buffer, read);
        }
        return RecurringData.writer(buffer, write);
    }

    public static RecurringData<String> createForString(PacketBuffer buffer, boolean reading) {
        return RecurringData.create(buffer, buf -> buf.func_150789_c(Short.MAX_VALUE), PacketBuffer::func_180714_a, reading);
    }

    public static <T> RecurringData<List<T>> createForList(PacketBuffer buffer, Function<PacketBuffer, T> read, BiConsumer<PacketBuffer, T> write, boolean reader) {
        return RecurringData.create(buffer, pb -> ListSerializer.readList(pb, read), (pb, l) -> ListSerializer.writeList(pb, l, write), reader);
    }

    public abstract void write(T var1);

    public abstract T read();

    public abstract int size();

    public int hits() {
        return this.hits;
    }

    private static class Writer<T>
    extends RecurringData<T> {
        protected final BiConsumer<PacketBuffer, T> write;
        protected final Object2IntMap<T> known = new Object2IntOpenHashMap();

        protected Writer(PacketBuffer io, BiConsumer<PacketBuffer, T> write) {
            super(io);
            this.write = write;
        }

        @Override
        public void write(T value) {
            int id = this.known.getOrDefault(value, -1);
            this.io.func_150787_b(id + 1);
            if (id < 0) {
                this.write.accept(this.io, (PacketBuffer)value);
                this.known.put(value, this.known.size());
            } else {
                ++this.hits;
            }
        }

        @Override
        public T read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.known.size();
        }
    }

    private static class Reader<T>
    extends RecurringData<T> {
        private final Function<PacketBuffer, T> read;
        protected final List<T> known = new ArrayList<T>();

        protected Reader(PacketBuffer io, Function<PacketBuffer, T> read) {
            super(io);
            this.read = read;
        }

        @Override
        public void write(T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T read() {
            int id = this.io.func_150792_a() - 1;
            if (id < 0) {
                T result = this.read.apply(this.io);
                this.known.add(result);
                return result;
            }
            ++this.hits;
            return this.known.get(id);
        }

        @Override
        public int size() {
            return this.known.size();
        }
    }
}

