/*
 * Decompiled with CFR 0.152.
 */
package malte0811.recipebuffers.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import java.util.BitSet;
import java.util.List;
import malte0811.recipebuffers.util.ListSerializer;
import malte0811.recipebuffers.util.RecurringData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ResourceLocationSerializer {
    private final RecurringData<String> namespaces;
    private final RecurringData<String> pathParts;
    private final PacketBuffer buffer;
    int rlPathBytes = 0;

    public ResourceLocationSerializer(PacketBuffer buffer, boolean reading) {
        this.buffer = buffer;
        this.namespaces = RecurringData.createForString(buffer, reading);
        this.pathParts = RecurringData.createForString(buffer, reading);
    }

    public void write(ResourceLocation toWrite) {
        this.namespaces.write(toWrite.func_110624_b());
        int lastSize = this.buffer.writerIndex();
        new SplitPath(toWrite.func_110623_a()).write(this.buffer, this.pathParts);
        this.rlPathBytes += this.buffer.writerIndex() - lastSize;
    }

    public ResourceLocation read() {
        String namespace = this.namespaces.read();
        return new ResourceLocation(namespace, new SplitPath(this.buffer, this.pathParts).assemble());
    }

    private static class SplitPath {
        private final List<String> parts;
        private final BitSet splitBySlash;

        private SplitPath(String path) {
            ImmutableList.Builder parts = ImmutableList.builder();
            BooleanArrayList splitBySlash = new BooleanArrayList();
            StringBuilder currentPart = new StringBuilder();
            for (char c : path.toCharArray()) {
                if (splitBySlash.size() < 8 && (c == '_' || c == '/')) {
                    splitBySlash.add(c == '/');
                    parts.add((Object)currentPart.toString());
                    currentPart.setLength(0);
                    continue;
                }
                currentPart.append(c);
            }
            parts.add((Object)currentPart.toString());
            this.parts = parts.build();
            this.splitBySlash = new BitSet(splitBySlash.size());
            for (int i = 0; i < splitBySlash.size(); ++i) {
                this.splitBySlash.set(i, splitBySlash.getBoolean(i));
            }
        }

        private SplitPath(PacketBuffer buffer, RecurringData<String> parts) {
            this.splitBySlash = BitSet.valueOf(new byte[]{buffer.readByte()});
            this.parts = ListSerializer.readList(buffer, $ -> (String)parts.read());
        }

        public void write(PacketBuffer buffer, RecurringData<String> parts) {
            byte[] splitBytes = this.splitBySlash.toByteArray();
            if (splitBytes.length > 0) {
                Preconditions.checkState((splitBytes.length == 1 ? 1 : 0) != 0);
                buffer.writeByte((int)splitBytes[0]);
            } else {
                buffer.writeByte(0);
            }
            ListSerializer.writeList(buffer, this.parts, ($, s) -> parts.write((String)s));
        }

        public String assemble() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.parts.size() - 1; ++i) {
                result.append(this.parts.get(i));
                if (this.splitBySlash.get(i)) {
                    result.append('/');
                    continue;
                }
                result.append('_');
            }
            result.append(this.parts.get(this.parts.size() - 1));
            return result.toString();
        }
    }
}

