/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockTile;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class EntangledBlock
extends BaseBlock {
    public static final BooleanProperty ON = BooleanProperty.func_177716_a((String)"on");

    public EntangledBlock() {
        super("block", true, AbstractBlock.Properties.func_200945_a((Material)new Material.Builder(MaterialColor.field_151650_B).func_200508_c().func_200506_i()).func_226897_b_(1.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185851_d).func_200943_b(2.0f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        if (worldIn.field_72995_K) {
            return ActionResultType.PASS;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_213453_ef() && stack.func_190926_b() && ((Boolean)state.func_177229_b((Property)ON)).booleanValue()) {
            ((EntangledBlockTile)worldIn.func_175625_s(pos)).bind(null, null);
            playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.unbind").color(TextFormatting.YELLOW).get(), true);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ON, (Comparable)Boolean.valueOf(false)));
        } else if (stack.func_77973_b() == Entangled.item) {
            CompoundNBT compound = stack.func_77978_p();
            if (compound == null || !compound.func_74767_n("bound")) {
                playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.no_selection").color(TextFormatting.RED).get(), true);
            } else {
                BlockPos pos2 = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
                if (pos2.equals((Object)pos)) {
                    playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.self").color(TextFormatting.RED).get(), true);
                } else {
                    if (!((Boolean)worldIn.func_180495_p(pos).func_177229_b((Property)ON)).booleanValue()) {
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ON, (Comparable)Boolean.valueOf(true)));
                    }
                    EntangledBlockTile tile = (EntangledBlockTile)worldIn.func_175625_s(pos);
                    if (compound.func_74779_i("dimension").equals(worldIn.func_234923_W_().func_240901_a_().toString())) {
                        if (EntangledConfig.maxDistance.get() == -1 || pos.func_218141_a((Vector3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                            tile.bind(pos2, compound.func_74779_i("dimension"));
                            playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.bind").color(TextFormatting.YELLOW).get(), true);
                        } else {
                            playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.too_far").color(TextFormatting.RED).get(), true);
                        }
                    } else if (EntangledConfig.allowDimensional.get().booleanValue()) {
                        tile.bind(pos2, compound.func_74779_i("dimension"));
                        playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.bind").color(TextFormatting.YELLOW).get(), true);
                    } else {
                        playerIn.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(TextFormatting.RED).get(), true);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EntangledBlockTile();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ON});
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)ON) != false ? VoxelShapes.func_197880_a() : VoxelShapes.func_197868_b();
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String key = EntangledConfig.allowDimensional.get().booleanValue() ? (EntangledConfig.maxDistance.get() == -1 ? "infinite_other_dimension" : "ranged_other_dimension") : (EntangledConfig.maxDistance.get() == -1 ? "infinite_same_dimension" : "ranged_same_dimension");
        IFormattableTextComponent maxDistance = TextComponents.string((String)Integer.toString(EntangledConfig.maxDistance.get())).color(TextFormatting.GOLD).get();
        tooltip.add((ITextComponent)TextComponents.translation((String)("entangled.entangled_block.info." + key), (Object[])new Object[]{maxDistance}).color(TextFormatting.AQUA).get());
        CompoundNBT tag = stack.func_196082_o().func_74775_l("tileData");
        if (tag.func_74764_b("bound") && tag.func_74767_n("bound")) {
            int x = tag.func_74762_e("boundx");
            int y = tag.func_74762_e("boundy");
            int z = tag.func_74762_e("boundz");
            IFormattableTextComponent dimension = TextComponents.dimension((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("dimension")))).color(TextFormatting.GOLD).get();
            IFormattableTextComponent name = TextComponents.blockState((BlockState)Block.func_196257_b((int)tag.func_74762_e("blockstate"))).color(TextFormatting.GOLD).get();
            IFormattableTextComponent xText = TextComponents.string((String)Integer.toString(x)).color(TextFormatting.GOLD).get();
            IFormattableTextComponent yText = TextComponents.string((String)Integer.toString(y)).color(TextFormatting.GOLD).get();
            IFormattableTextComponent zText = TextComponents.string((String)Integer.toString(z)).color(TextFormatting.GOLD).get();
            tooltip.add((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.info.bound", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(TextFormatting.YELLOW).get());
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        CompoundNBT compound = stack.func_196082_o().func_74775_l("tileData");
        if (compound.func_74767_n("bound")) {
            PlayerEntity player = context.func_195999_j();
            BlockPos pos = context.func_195995_a();
            BlockPos pos2 = new BlockPos(compound.func_74762_e("boundx"), compound.func_74762_e("boundy"), compound.func_74762_e("boundz"));
            if (compound.func_74779_i("dimension").equals(context.func_195991_k().func_234923_W_().func_240901_a_().toString())) {
                if (EntangledConfig.maxDistance.get() >= 0 && !pos.func_218141_a((Vector3i)pos2, (double)EntangledConfig.maxDistance.get().intValue() + 0.5)) {
                    if (player != null && !context.func_195991_k().field_72995_K) {
                        player.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.too_far").color(TextFormatting.RED).get(), true);
                    }
                    return null;
                }
            } else if (!EntangledConfig.allowDimensional.get().booleanValue()) {
                if (player != null && !context.func_195991_k().field_72995_K) {
                    player.func_146105_b((ITextComponent)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(TextFormatting.RED).get(), true);
                }
                return null;
            }
            return (BlockState)this.func_176223_P().func_206870_a((Property)ON, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        return entity instanceof EntangledBlockTile ? ((EntangledBlockTile)entity).getAnalogOutputSignal() : 0;
    }

    public boolean func_149744_f(BlockState p_60571_) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        TileEntity entity = world.func_175625_s(pos);
        return entity instanceof EntangledBlockTile ? ((EntangledBlockTile)entity).getRedstoneSignal(direction) : 0;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        TileEntity entity = world.func_175625_s(pos);
        return entity instanceof EntangledBlockTile ? ((EntangledBlockTile)entity).getDirectRedstoneSignal(direction) : 0;
    }
}

