/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.lib.client.GuiTools;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlClientScreenModule;
import mcjty.rftoolsstorage.modules.scanner.items.StorageControlScreenModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class StorageControlModuleItem
extends GenericModuleItem
implements INBTPreservingIngredient,
ITabletSupport {
    public Item getInstalledTablet() {
        return (Item)StorageScannerModule.TABLET_SCANNER.get();
    }

    public void openGui(@Nonnull PlayerEntity player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        final BlockPos pos = ModuleTools.getPositionFromModule((ItemStack)containingItem);
        RegistryKey dimensionType = ModuleTools.getDimensionFromModule((ItemStack)containingItem);
        GuiTools.openRemoteGui((PlayerEntity)player, (RegistryKey)dimensionType, (BlockPos)pos, te -> new INamedContainerProvider(){
            final /* synthetic */ TileEntity val$te;
            {
                this.val$te = tileEntity;
            }

            @Nonnull
            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Remote Storage Scanner");
            }

            @Nonnull
            public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
                StorageScannerContainer container = StorageScannerContainer.createRemote(id, pos, (StorageScannerTileEntity)this.val$te);
                this.val$te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> container.setupInventories((IItemHandler)h, inventory));
                return container;
            }
        });
    }

    protected int getUses(ItemStack stack) {
        return (Integer)StorageScannerConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public StorageControlModuleItem() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1).func_200916_a(RFToolsStorage.setup.getTab()));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IStorageScanner) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockReader)world, pos)) {
                name = Tools.getReadableName((World)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (RegistryKey)world.func_234923_W_(), (BlockPos)pos, (String)name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)"Storage module is cleared");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public Class<StorageControlScreenModule> getServerScreenModule() {
        return StorageControlScreenModule.class;
    }

    public Class<StorageControlClientScreenModule> getClientScreenModule() {
        return StorageControlClientScreenModule.class;
    }

    public String getModuleName() {
        return "Stor";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.ghostStack("stack0").ghostStack("stack1").ghostStack("stack2").nl().ghostStack("stack3").ghostStack("stack4").ghostStack("stack5").nl().ghostStack("stack6").ghostStack("stack7").ghostStack("stack8").nl().toggle("starred", "Starred", new String[]{"If enabled only count items", "in 'starred' inventories", "(mark inventories in storage scanner)"}).block("monitor").nl();
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.emptyList();
    }
}

