/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.blocks;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Cached;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.api.storage.IInventoryTracker;
import mcjty.rftoolsbase.api.storage.IModularStorage;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.InventoriesItemSource;
import mcjty.rftoolsstorage.craftinggrid.StorageCraftingTools;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.GlobalStorageItemWrapper;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ModularStorageTileEntity
extends GenericTileEntity
implements IInventoryTracker,
CraftingGridProvider,
JEIRecipeAcceptor,
IModularStorage {
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    @Cap(type=CapType.ITEMS)
    private final LazyOptional<IItemHandler> globalHandler = LazyOptional.of(this::createGlobalHandler);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Modular Storage").containerSupplier(windowId -> new ModularStorageContainer((int)windowId, this.func_174877_v(), this)).itemHandler(() -> (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h).orElseThrow(RuntimeException::new)).setupSync((GenericTileEntity)this));
    private GlobalStorageItemWrapper globalWrapper;
    private final ItemStackHandler cardHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            if (slot == 0) {
                if (ModularStorageTileEntity.this.globalWrapper != null) {
                    StorageInfo info = ModularStorageTileEntity.this.getStorageInfo();
                    ModularStorageTileEntity.this.globalWrapper.setInfo(info);
                }
            } else if (slot == 2) {
                ModularStorageTileEntity.this.filterCache.clear();
            }
            ModularStorageTileEntity.this.func_70296_d();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (ModularStorageTileEntity.this.locked) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (ModularStorageTileEntity.this.locked) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private final CraftingGrid craftingGrid = new CraftingGrid();
    private String sortMode = "";
    private String viewMode = "";
    private boolean groupMode = false;
    private String filter = "";
    private boolean locked = false;
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<String> PARAM_VIEWMODE = new Key("viewmode", Type.STRING);
    public static final Key<String> PARAM_SORTMODE = new Key("sortmode", Type.STRING);
    public static final Key<Boolean> PARAM_GROUPMODE = new Key("groupmode", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_LOCKED = new Key("locked", Type.BOOLEAN);
    @ServerCommand
    public static final Command<?> CMD_SETTINGS = Command.create((String)"storage.settings", (te, player, params) -> {
        te.setFilter((String)params.get(PARAM_FILTER));
        te.setViewMode((String)params.get(PARAM_VIEWMODE));
        te.setSortMode((String)params.get(PARAM_SORTMODE));
        te.setGroupMode((Boolean)params.get(PARAM_GROUPMODE));
        te.setLocked((Boolean)params.get(PARAM_LOCKED));
        te.func_70296_d();
    });
    @ServerCommand
    public static final Command<?> CMD_CLEARGRID = Command.create((String)"clearGrid", (te, player, params) -> te.clearGrid());
    @ServerCommand
    public static final Command<?> CMD_CYCLE = Command.create((String)"cycle", (te, player, params) -> te.cycle());
    @ServerCommand
    public static final Command<?> CMD_COMPACT = Command.create((String)"compact", (te, player, params) -> te.compact());

    public ModularStorageTileEntity() {
        super((TileEntityType)ModularStorageModule.TYPE_MODULAR_STORAGE.get());
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setStackInSlot(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(PlayerEntity player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), 0);
        this.globalHandler.ifPresent(h -> itemSource.add((IItemHandler)h, 0));
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return new int[0];
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.func_70296_d();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.func_70296_d();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.func_70296_d();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.func_70296_d();
    }

    public int getRenderLevel() {
        return 0;
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
    }

    public void syncInventoryFromServer(String sortMode, String viewMode, boolean groupMode, String filter, boolean locked) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.locked = locked;
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.sortMode = tagCompound.func_74779_i("sortMode");
        this.viewMode = tagCompound.func_74779_i("viewMode");
        this.groupMode = tagCompound.func_74767_n("groupMode");
        this.filter = tagCompound.func_74779_i("filter");
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    protected void readCaps(CompoundNBT tagCompound) {
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            this.cardHandler.deserializeNBT(infoTag.func_74775_l("Cards"));
            this.locked = infoTag.func_74764_b("locked") ? infoTag.func_74767_n("locked") : !this.cardHandler.getStackInSlot(0).func_190926_b();
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("sortMode", this.sortMode);
        tagCompound.func_74778_a("viewMode", this.viewMode);
        tagCompound.func_74757_a("groupMode", this.groupMode);
        tagCompound.func_74778_a("filter", this.filter);
        tagCompound.func_218657_a("grid", (INBT)this.craftingGrid.writeToNBT());
        return tagCompound;
    }

    protected void writeCaps(CompoundNBT tagCompound) {
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_218657_a("Cards", (INBT)this.cardHandler.serializeNBT());
        infoTag.func_74757_a("locked", this.locked);
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.func_70296_d();
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void cycle() {
    }

    private void compact() {
    }

    @Nonnull
    public StorageInfo getStorageInfo() {
        ItemStack storageCard = this.cardHandler.getStackInSlot(0);
        if (storageCard.func_190926_b()) {
            return StorageInfo.EMPTY;
        }
        Item item = storageCard.func_77973_b();
        if (item instanceof StorageModuleItem) {
            UUID uuid = StorageModuleItem.getOrCreateUUID(storageCard);
            int version = StorageModuleItem.getVersion(storageCard);
            int size = StorageModuleItem.getSize(storageCard);
            String createdBy = StorageModuleItem.getCreatedBy(storageCard);
            return new StorageInfo(uuid, version, size, createdBy);
        }
        return StorageInfo.EMPTY;
    }

    public int getVersion() {
        return this.getStorageInfo().getVersion();
    }

    public int getMaxSize() {
        StorageInfo info = this.getStorageInfo();
        return info.getSize();
    }

    private Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.cardHandler.getStackInSlot(2));
    }

    @Nonnull
    private IItemHandlerModifiable createGlobalHandler() {
        StorageInfo info = this.getStorageInfo();
        if (this.globalWrapper == null) {
            this.globalWrapper = new GlobalStorageItemWrapper(info, this.field_145850_b.field_72995_K){

                @Override
                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    boolean rc = super.isItemValid(slot, stack);
                    if (!rc) {
                        return false;
                    }
                    if (!ModularStorageTileEntity.this.cardHandler.getStackInSlot(2).func_190926_b() && ModularStorageTileEntity.this.filterCache.get() != null) {
                        return ((Predicate)ModularStorageTileEntity.this.filterCache.get()).test(stack);
                    }
                    return true;
                }

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    if (!ModularStorageTileEntity.this.locked) {
                        return stack;
                    }
                    return super.insertItem(slot, stack, simulate);
                }

                @Override
                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (!ModularStorageTileEntity.this.locked) {
                        return ItemStack.field_190927_a;
                    }
                    return super.extractItem(slot, amount, simulate);
                }
            };
            if (!this.field_145850_b.field_72995_K) {
                this.globalWrapper.setListener((version, slot) -> {
                    ItemStack storageSlot = this.cardHandler.getStackInSlot(0);
                    if (storageSlot.func_77973_b() instanceof StorageModuleItem) {
                        storageSlot.func_196082_o().func_74768_a("version", version);
                    }
                    this.markDirtyQuick();
                });
            }
        } else {
            this.globalWrapper.setInfo(info);
        }
        return this.globalWrapper;
    }

    public IItemHandler getCardHandler() {
        return this.cardHandler;
    }

    public int getNumStacks() {
        int cnt = 0;
        if (this.globalWrapper == null) {
            this.createGlobalHandler();
        }
        for (int i = 0; i < this.globalWrapper.getSlots(); ++i) {
            if (this.globalWrapper.getStackInSlot(i).func_190926_b()) continue;
            ++cnt;
        }
        return cnt;
    }
}

