/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.MilkJarTileEntity;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CowJarTileEntity
extends MilkJarTileEntity
implements ITickableTileEntity,
IMutableNameable {
    private static final int UPDATE_INTERVAL = 20;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private ITextComponent customName;
    private boolean compressedCow;

    public CowJarTileEntity() {
        super(ModTileEntities.cowJar);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tagCompound.func_74779_i("CustomName"));
        }
        this.compressedCow = tagCompound.func_74767_n("CompressedCow");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        if (this.customName != null) {
            tagCompound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        tagCompound.func_74757_a("CompressedCow", this.compressedCow);
        return super.func_189515_b(tagCompound);
    }

    public void func_73660_a() {
        if (this.milkAmount < 32000.0f) {
            double milkToAdd = (Double)CookingForBlockheadsConfig.COMMON.cowJarMilkPerTick.get();
            if (this.compressedCow) {
                milkToAdd *= ((Double)CookingForBlockheadsConfig.COMMON.compressedCowJarMilkMultiplier.get()).doubleValue();
            }
            this.milkAmount = (float)((double)this.milkAmount + milkToAdd);
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean isCompressedCow() {
        return this.compressedCow;
    }

    public void setCompressedCow(boolean compressedCow) {
        this.compressedCow = compressedCow;
    }

    @Override
    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
        this.func_70296_d();
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public ITextComponent getDefaultName() {
        if (this.compressedCow) {
            return new TranslationTextComponent("container.cookingforblockheads.cow_jar_compressed");
        }
        return new TranslationTextComponent("container.cookingforblockheads.cow_jar");
    }
}

