/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelMungus;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityMungus;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;

public class RenderMungus
extends MobRenderer<EntityMungus, ModelMungus> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexsmobs:textures/entity/mungus.png");
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("alexsmobs:textures/entity/mungus_beam.png");
    private static final ResourceLocation TEXTURE_BEAM_OVERLAY = new ResourceLocation("alexsmobs:textures/entity/mungus_beam_overlay.png");
    private static final ResourceLocation TEXTURE_SACK_OVERLAY = new ResourceLocation("alexsmobs:textures/entity/mungus_sack.png");
    private static final ResourceLocation TEXTURE_SHOES = new ResourceLocation("alexsmobs:textures/entity/mungus_shoes.png");
    private static final RenderType beamType = AMRenderTypes.getMungusBeam(BEAM_TEXTURE);

    public RenderMungus(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelMungus(0.0f), 0.5f);
        this.func_177094_a(new MungusSackLayer(this));
        this.func_177094_a(new MungusMushroomLayer(this));
    }

    protected boolean func_230495_a_(EntityMungus mungus) {
        return mungus.isReverting();
    }

    private static void func_229108_a_(IVertexBuilder p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_) {
        p_229108_0_.func_227888_a_(p_229108_1_, p_229108_3_, p_229108_4_, p_229108_5_).func_225586_a_(p_229108_6_, p_229108_7_, p_229108_8_, 255).func_225583_a_(p_229108_9_, p_229108_10_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(240).func_227887_a_(p_229108_2_, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    protected void applyRotations(EntityMungus entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.field_70725_aQ > 0) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            f = MathHelper.func_76129_c((float)f);
            if (f > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f * -90.0f));
        } else {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected float getDeathMaxRotation(EntityMungus p_77037_1_) {
        return 0.0f;
    }

    protected void preRenderCallback(EntityMungus entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        String s = TextFormatting.func_110646_a((String)entitylivingbaseIn.func_200200_C_().getString());
        if (s != null && s.toLowerCase().contains("drip")) {
            matrixStackIn.func_227861_a_(0.0, entitylivingbaseIn.func_70631_g_() ? (double)-0.075f : (double)-0.15f, 0.0);
        }
    }

    public boolean shouldRender(EntityMungus livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        BlockPos pos;
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.getBeamTarget() != null && (pos = livingEntityIn.getBeamTarget()) != null) {
            Vector3d vector3d = Vector3d.func_237491_b_((Vector3i)pos);
            Vector3d vector3dCorner = Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(1.0, 1.0, 1.0);
            Vector3d vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.func_70047_e(), 1.0f);
            return camera.func_228957_a_(new AxisAlignedBB(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c)) || camera.func_228957_a_(new AxisAlignedBB(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3dCorner.field_72450_a, vector3dCorner.field_72448_b, vector3dCorner.field_72449_c));
        }
        return false;
    }

    private Vector3d getPosition(LivingEntity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70142_S, (double)entityLivingBaseIn.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70137_T, (double)entityLivingBaseIn.func_226278_cu_()) + p_177110_2_;
        double d2 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70136_U, (double)entityLivingBaseIn.func_226281_cx_());
        return new Vector3d(d0, d1, d2);
    }

    public void render(EntityMungus entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        BlockPos target = entityIn.getBeamTarget();
        if (target != null) {
            float f = 1.0f;
            float f1 = (float)entityIn.field_70170_p.func_82737_E() + partialTicks;
            float f2 = -1.0f * (f1 * 0.15f % 1.0f);
            float f3 = 1.13f;
            if (entityIn.func_70631_g_()) {
                f3 = 0.555f;
            }
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
            Vector3d vector3d = Vector3d.func_237490_a_((Vector3i)target, (double)0.15f);
            Vector3d vector3d1 = this.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vector3d vector3d2 = vector3d.func_178788_d(vector3d1);
            float f4 = (float)vector3d2.func_72433_c();
            vector3d2 = vector3d2.func_72432_b();
            float f5 = (float)Math.acos(vector3d2.field_72448_b);
            float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
            boolean i = true;
            float f7 = f1 * 0.05f * 1.5f;
            float f8 = 1.0f;
            int j = (int)(f8 * 255.0f);
            int k = (int)(f8 * 255.0f);
            int l = (int)(f8 * 255.0f);
            float f9 = 0.2f;
            float f10 = 0.282f;
            float f11 = MathHelper.func_76134_b((float)2.3561945f) * 0.8f;
            float f12 = MathHelper.func_76126_a((float)2.3561945f) * 0.8f;
            float f13 = MathHelper.func_76134_b((float)0.7853982f) * 0.8f;
            float f14 = MathHelper.func_76126_a((float)0.7853982f) * 0.8f;
            float f15 = MathHelper.func_76134_b((float)3.926991f) * 0.8f;
            float f16 = MathHelper.func_76126_a((float)3.926991f) * 0.8f;
            float f17 = MathHelper.func_76134_b((float)5.4977875f) * 0.8f;
            float f18 = MathHelper.func_76126_a((float)5.4977875f) * 0.8f;
            float f19 = MathHelper.func_76134_b((float)((float)Math.PI)) * 0.4f;
            float f20 = MathHelper.func_76126_a((float)((float)Math.PI)) * 0.4f;
            float f21 = MathHelper.func_76134_b((float)0.0f) * 0.4f;
            float f22 = MathHelper.func_76126_a((float)0.0f) * 0.4f;
            float f23 = MathHelper.func_76134_b((float)1.5707964f) * 0.4f;
            float f24 = MathHelper.func_76126_a((float)1.5707964f) * 0.4f;
            float f25 = MathHelper.func_76134_b((float)4.712389f) * 0.4f;
            float f26 = MathHelper.func_76126_a((float)4.712389f) * 0.4f;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 0.5f + f29;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(beamType);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entityIn.field_70173_aa % 4 > 1) {
                f31 = 0.5f;
            }
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            RenderMungus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(EntityMungus entity) {
        return TEXTURE;
    }

    class MungusMushroomLayer
    extends LayerRenderer<EntityMungus, ModelMungus> {
        public MungusMushroomLayer(RenderMungus p_i50928_1_) {
            super((IEntityRenderer)p_i50928_1_);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityMungus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            BlockState blockstate = entitylivingbaseIn.getMushroomState();
            if (blockstate == null) {
                return;
            }
            int i = LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f);
            boolean altOrder = entitylivingbaseIn.isAltOrderMushroom();
            int mushroomCount = entitylivingbaseIn.getMushroomCount();
            matrixStackIn.func_227860_a_();
            if (entitylivingbaseIn.func_70631_g_()) {
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                matrixStackIn.func_227861_a_(0.0, 1.5, 0.0);
            }
            matrixStackIn.func_227860_a_();
            this.translateToBody(matrixStackIn);
            if (mushroomCount == 1 && !altOrder || mushroomCount >= 2) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)0.2f, (double)-1.4f, 0.15);
                matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
                matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.func_227865_b_();
            }
            if (mushroomCount == 1 && altOrder || mushroomCount >= 2) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)-0.2f, -1.5, -0.2);
                matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
                matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.func_227865_b_();
            }
            if (mushroomCount >= 3) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)0.76f, (double)-0.4f, 0.1);
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
                matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
                matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.func_227865_b_();
            }
            if (mushroomCount >= 4) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)-0.76f, -1.0, 0.1);
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-60.0f));
                matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
                matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.func_227865_b_();
            }
            if (mushroomCount >= 5) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)-0.76f, (double)-0.1f, 0.1);
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-100.0f));
                matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
                matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
                matrixStackIn.func_227865_b_();
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }

        protected void translateToBody(MatrixStack matrixStack) {
            ((ModelMungus)this.func_215332_c()).root.func_228307_a_(matrixStack);
            ((ModelMungus)this.func_215332_c()).body.func_228307_a_(matrixStack);
        }
    }

    class MungusSackLayer
    extends LayerRenderer<EntityMungus, ModelMungus> {
        public MungusSackLayer(RenderMungus p_i50928_1_) {
            super((IEntityRenderer)p_i50928_1_);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityMungus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            String s;
            IVertexBuilder lead = bufferIn.getBuffer(AMRenderTypes.getEyesFlickering(TEXTURE_SACK_OVERLAY, 0.0f));
            float alpha = 0.75f + (MathHelper.func_76134_b((float)(ageInTicks * 0.2f)) + 1.0f) * 0.125f;
            ((ModelMungus)this.func_215332_c()).func_225598_a_(matrixStackIn, lead, 240, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
            if (entitylivingbaseIn.getBeamTarget() != null) {
                IVertexBuilder beam = bufferIn.getBuffer(AMRenderTypes.getEyesFlickering(TEXTURE_BEAM_OVERLAY, 0.0f));
                float beamAlpha = 0.75f + (MathHelper.func_76134_b((float)(ageInTicks * 1.0f)) + 1.0f) * 0.125f;
                ((ModelMungus)this.func_215332_c()).func_225598_a_(matrixStackIn, beam, 240, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, beamAlpha);
            }
            if ((s = TextFormatting.func_110646_a((String)entitylivingbaseIn.func_200200_C_().getString())) != null && s.toLowerCase().contains("drip")) {
                IVertexBuilder shoeBuffer = bufferIn.getBuffer(AMRenderTypes.func_228640_c_((ResourceLocation)TEXTURE_SHOES));
                matrixStackIn.func_227860_a_();
                ((ModelMungus)this.func_215332_c()).renderShoes();
                ((ModelMungus)this.func_215332_c()).func_225598_a_(matrixStackIn, shoeBuffer, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                ((ModelMungus)this.func_215332_c()).postRenderShoes();
                matrixStackIn.func_227865_b_();
            }
        }
    }
}

