/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.codec.digest.DigestUtils;
import sonar.fluxnetworks.common.network.C2SNetMsg;
import sonar.fluxnetworks.common.network.S2CNetMsg;

public class NetworkHandler {
    static final NetworkHandler sInstance = new NetworkHandler("fluxnetworks", "main_network");
    private final ResourceLocation mChannel;
    private final String mProtocol;
    private final Broadcaster mBroadcaster = new Broadcaster();

    public NetworkHandler(@Nonnull String modid, @Nonnull String name) {
        this.mProtocol = DigestUtils.md5Hex((byte[])ModList.get().getModFileById(modid).getMods().stream().map(iModInfo -> iModInfo.getVersion().getQualifier()).collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8));
        this.mChannel = new ResourceLocation(modid, name);
        EventNetworkChannel network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.mChannel).networkProtocolVersion(this::getProtocolVersion).clientAcceptedVersions(this::checkS2CProtocol).serverAcceptedVersions(this::checkC2SProtocol).eventNetworkChannel();
        if (FMLEnvironment.dist.isClient()) {
            network.addListener(this::onS2CMessageReceived);
        }
        network.addListener(this::onC2SMessageReceived);
    }

    public static void initialize() {
    }

    public String getProtocolVersion() {
        return this.mProtocol;
    }

    private boolean checkS2CProtocol(@Nonnull String serverProtocol) {
        return serverProtocol.equals(this.mProtocol);
    }

    private boolean checkC2SProtocol(@Nonnull String clientProtocol) {
        return clientProtocol.equals(this.mProtocol);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onS2CMessageReceived(@Nonnull NetworkEvent.ServerCustomPayloadEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            C2SNetMsg.sFunctors[event.getPayload().readShort()].f(event.getPayload(), player);
        }
        event.getPayload().release();
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    private void onC2SMessageReceived(@Nonnull NetworkEvent.ClientCustomPayloadEvent event) {
        ServerPlayerEntity player = ((NetworkEvent.Context)event.getSource().get()).getSender();
        if (player != null) {
            S2CNetMsg.sFunctors[event.getPayload().readShort()].f(event.getPayload(), player);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    @Nonnull
    public PacketBuffer targetAt(int index) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeShort(index);
        return buffer;
    }

    @Nonnull
    public Broadcaster getBroadcaster(@Nonnull PacketBuffer buf) {
        Broadcaster b = this.mBroadcaster;
        b.buf = buf;
        return b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(@Nonnull PacketBuffer buf) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            connection.func_147297_a((IPacket)new CCustomPayloadPacket(this.mChannel, buf));
        }
    }

    public class Broadcaster {
        private PacketBuffer buf;

        public void sendToPlayer(@Nonnull PlayerEntity player) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.buf = null;
        }

        public void sendToPlayer(@Nonnull ServerPlayerEntity player) {
            player.field_71135_a.func_147359_a((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.buf = null;
        }

        public void sendToPlayers(@Nonnull Iterable<? extends PlayerEntity> players) {
            SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf);
            for (PlayerEntity playerEntity : players) {
                ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a((IPacket)packet);
            }
            this.buf = null;
        }

        public void sendToAll() {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148540_a((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.buf = null;
        }

        public void sendToDimension(@Nonnull RegistryKey<World> dimension) {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232642_a_((IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf), dimension);
            this.buf = null;
        }

        public void sendToNearby(@Nullable ServerPlayerEntity excluded, double x, double y, double z, double radius, @Nonnull RegistryKey<World> dimension) {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148543_a((PlayerEntity)excluded, x, y, z, radius, dimension, (IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.buf = null;
        }

        public void sendToTrackingEntity(@Nonnull Entity entity) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217218_b(entity, (IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.buf = null;
        }

        public void sendToTrackingAndSelf(@Nonnull Entity entity) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a(entity, (IPacket)new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf));
            this.buf = null;
        }

        public void sendToTrackingChunk(@Nonnull Chunk chunk) {
            SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket(NetworkHandler.this.mChannel, this.buf);
            ((ServerWorld)chunk.func_177412_p()).func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(arg_0 -> Broadcaster.lambda$sendToTrackingChunk$0((IPacket)packet, arg_0));
            this.buf = null;
        }

        private static /* synthetic */ void lambda$sendToTrackingChunk$0(IPacket packet, ServerPlayerEntity player) {
            player.field_71135_a.func_147359_a(packet);
        }
    }
}

