/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popup.PopupMemberEdit;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.network.C2SNetMsg;

public class GuiTabMembers
extends GuiTabPages<NetworkMember> {
    public InvisibleButton redirectButton;
    public NetworkMember selectedPlayer;
    private int timer;

    public GuiTabMembers(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 146;
        C2SNetMsg.requestNetworkUpdate(this.network, 22);
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_MEMBER;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.networkValid) {
            String str2 = this.accessLevel.getName();
            this.field_230712_o_.func_238421_b_(matrixStack, str2, (float)(158 - this.field_230712_o_.func_78256_a(str2)), 10.0f, 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + FluxTranslate.SORTING_SMART.t(), 19.0f, 10.0f, 0xFFFFFF);
            super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        } else {
            super.drawForegroundLayer(matrixStack, mouseX, mouseY);
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_MEMBER, this.navigationTabs);
        if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
            this.func_230480_a_((Widget)this.redirectButton);
        }
        this.refreshPages(Lists.newArrayList(this.network.getAllMembers()));
    }

    @Override
    protected void onElementClicked(NetworkMember element, int mouseButton) {
        if (mouseButton == 0) {
            this.selectedPlayer = element;
            this.openPopUp(new PopupMemberEdit(this, this.player));
        }
    }

    @Override
    public void renderElement(MatrixStack matrixStack, NetworkMember element, int x, int y) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227709_e_();
        int color = element.getAccessLevel().getColor();
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)f, (float)f1, (float)f2, (float)0.8f);
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.GUI_BAR);
        this.func_238474_b_(matrixStack, x, y, 0, 16, this.elementWidth, this.elementHeight);
        if (element.getPlayerUUID().equals(this.player.func_110124_au())) {
            GuiTabMembers.func_238467_a_((MatrixStack)matrixStack, (int)(x - 4), (int)(y + 1), (int)(x - 2), (int)(y + this.elementHeight - 1), (int)-855638017);
            GuiTabMembers.func_238467_a_((MatrixStack)matrixStack, (int)(x + this.elementWidth + 2), (int)(y + 1), (int)(x + this.elementWidth + 4), (int)(y + this.elementHeight - 1), (int)-855638017);
        }
        this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.WHITE + element.getCachedName(), (float)(x + 4), (float)(y + 2), 0xFFFFFF);
        String p = element.getAccessLevel().getName();
        this.field_230712_o_.func_238421_b_(matrixStack, p, (float)(x + 142 - this.field_230712_o_.func_78256_a(p)), (float)(y + 2), 0xFFFFFF);
    }

    @Override
    public void renderElementTooltip(MatrixStack matrixStack, NetworkMember element, int mouseX, int mouseY) {
        if (this.hasActivePopup()) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(FluxTranslate.USERNAME.t() + ": " + TextFormatting.AQUA + element.getCachedName());
        String permission = element.getAccessLevel().getName() + (element.getPlayerUUID().equals(this.player.func_110124_au()) ? " (" + FluxTranslate.YOU.t() + ")" : "");
        strings.add(FluxTranslate.ACCESS.t() + ": " + TextFormatting.RESET + permission);
        this.screenUtils.drawHoverTooltip(matrixStack, strings, mouseX + 4, mouseY - 8);
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        super.mouseClickedMain(mouseX, mouseY, mouseButton);
        return false;
    }

    @Override
    public void onFeedbackAction(@Nonnull FeedbackInfo info) {
        super.onFeedbackAction(info);
        if (info == FeedbackInfo.SUCCESS && this.hasActivePopup()) {
            Optional<NetworkMember> n = this.elements.stream().filter(f -> f.getPlayerUUID().equals(this.selectedPlayer.getPlayerUUID())).findFirst();
            if (n.isPresent()) {
                this.selectedPlayer = n.get();
                this.openPopUp(new PopupMemberEdit(this, this.player));
            } else {
                this.closePopUp();
            }
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.timer == 0) {
            C2SNetMsg.requestAccessUpdate(this.network.getNetworkID());
        }
        if (this.timer == 4 || this.timer == 14) {
            this.refreshPages(Lists.newArrayList(this.network.getAllMembers()));
        }
        ++this.timer;
        this.timer %= 40;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(NetworkMember::getAccessLevel).thenComparing(NetworkMember::getCachedName));
        this.refreshCurrentPageInternal();
    }
}

