/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.WasteEjectionSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ReactorControllerEntity
extends AbstractReactorEntity
implements INamedContainerProvider,
INetworkTileEntitySyncProvider {
    public static String COMMAND_WASTE_AUTOMATIC = "autowaste";
    public static String COMMAND_WASTE_MANUAL = "manualwaste";
    public static String COMMAND_SCRAM = "scram";
    public static String COMMAND_VOID_REACTANTS = "voidr";

    public ReactorControllerEntity() {
        super((TileEntityType)Content.TileEntityTypes.REACTOR_CONTROLLER.get());
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_ACTIVATE, rce -> rce.setReactorActive(true)).addServerHandler(CommonConstants.COMMAND_DEACTIVATE, rce -> rce.setReactorActive(false)).addServerHandler(COMMAND_WASTE_AUTOMATIC, rce -> rce.setWasteEjectionMode(WasteEjectionSetting.Automatic)).addServerHandler(COMMAND_WASTE_MANUAL, rce -> rce.setWasteEjectionMode(WasteEjectionSetting.Manual)).addServerHandler(COMMAND_VOID_REACTANTS, ReactorControllerEntity::voidReactants).addServerHandler(COMMAND_SCRAM, ReactorControllerEntity::scram).build((AbstractModBlockEntity)this));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return (byte)(this.isMachineAssembled() ? (this.isReactorActive() ? 1 : 2) : 0);
    }

    @Override
    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled(controller);
        this.listenForControllerDataUpdates();
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.requestClientRenderUpdate();
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.executeOnController(c -> c.getDebugMessages(side, messages));
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void enlistForUpdates(ServerPlayerEntity player, boolean updateNow) {
        this.executeOnController(c -> c.enlistForUpdates(player, updateNow));
    }

    public void delistFromUpdates(ServerPlayerEntity player) {
        this.executeOnController(c -> c.delistFromUpdates(player));
    }

    public void sendUpdates() {
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.REACTOR_CONTROLLER.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayerEntity)((ServerPlayerEntity)player));
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    private void setWasteEjectionMode(WasteEjectionSetting mode) {
        this.executeOnController(c -> c.setWasteEjectionMode(mode));
    }

    private void scram() {
        this.executeOnController(c -> c.setControlRodsInsertionRatio(100));
        this.setReactorActive(false);
    }

    private void voidReactants() {
        this.executeOnController(MultiblockReactor::voidReactants);
    }
}

