/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen;

import it.zerono.mods.extremereactors.datagen.AbstractMultiblockBlockStateGenerator;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TurbineBlockStateGenerator
extends AbstractMultiblockBlockStateGenerator {
    private final ModelFile TRANSPARENT_BLOCK_MODEL;
    private final ResourceLocation ROTOR_SHAFT_Z_0C_ID;
    private final ResourceLocation ROTOR_SHAFT_Z_2C_ID;
    private final ResourceLocation ROTOR_SHAFT_Z_2CY_ID;
    private final ResourceLocation ROTOR_SHAFT_Z_4C_ID;
    private final ResourceLocation ROTOR_BLADE_Z_ID;
    private final ResourceLocation ROTOR_BLADE_ZY_ID;

    public TurbineBlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, exFileHelper);
        BlockModelProvider mbp = this.models();
        this.TRANSPARENT_BLOCK_MODEL = mbp.getExistingFile(this.modLoc("block/transparentblock"));
        this.ROTOR_SHAFT_Z_0C_ID = this.modLoc(TurbineBlockStateGenerator.fullResourceName("rotor_shaft_z_0c"));
        this.ROTOR_SHAFT_Z_2C_ID = this.modLoc(TurbineBlockStateGenerator.fullResourceName("rotor_shaft_z_2c"));
        this.ROTOR_SHAFT_Z_2CY_ID = this.modLoc(TurbineBlockStateGenerator.fullResourceName("rotor_shaft_z_2cy"));
        this.ROTOR_SHAFT_Z_4C_ID = this.modLoc(TurbineBlockStateGenerator.fullResourceName("rotor_shaft_z_4c"));
        this.ROTOR_BLADE_Z_ID = this.modLoc(TurbineBlockStateGenerator.fullResourceName("rotor_blade_z"));
        this.ROTOR_BLADE_ZY_ID = this.modLoc(TurbineBlockStateGenerator.fullResourceName("rotor_blade_zy"));
    }

    @Nonnull
    public String func_200397_b() {
        return "Extreme Reactors 2 Turbine blockstates and models";
    }

    protected void registerStatesAndModels() {
        String variant = "turbine/basic";
        this.genAssembledPlatingModel(variant);
        this.genFrame((Supplier)Content.Blocks.TURBINE_CASING_BASIC, "casing", variant);
        this.genGlass((Supplier)Content.Blocks.TURBINE_GLASS_BASIC, "glass", variant);
        this.genController((Supplier<? extends Block>)Content.Blocks.TURBINE_CONTROLLER_BASIC, variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_ROTORBEARING_BASIC, "bearing", variant, true, new String[0]);
        this.genShaft((Supplier<? extends Block>)Content.Blocks.TURBINE_ROTORSHAFT_BASIC, "rotorshaft", variant);
        this.genBlade((Supplier<? extends Block>)Content.Blocks.TURBINE_ROTORBLADE_BASIC, "rotorblade", variant);
        this.genRedstonePort((Supplier<? extends Block>)Content.Blocks.TURBINE_REDSTONEPORT_BASIC, variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_POWERTAP_FE_ACTIVE_BASIC, "powertap_fe_active", variant, true, new String[0]);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_POWERTAP_FE_PASSIVE_BASIC, "powertap_fe_passive", variant, true, new String[0]);
        this.genFluidPort((Supplier<? extends Block>)Content.Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC, "fluidport_forge_active", variant);
        this.genFluidPort((Supplier<? extends Block>)Content.Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC, "fluidport_forge_passive", variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_BASIC, "creative_steam_generator", variant, true, new String[0]);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_CHARGINGPORT_FE_BASIC, "charging", variant, true, new String[0]);
        variant = "turbine/reinforced";
        this.genAssembledPlatingModel(variant);
        this.genFrame((Supplier)Content.Blocks.TURBINE_CASING_REINFORCED, "casing", variant);
        this.genGlass((Supplier)Content.Blocks.TURBINE_GLASS_REINFORCED, "glass", variant);
        this.genController((Supplier<? extends Block>)Content.Blocks.TURBINE_CONTROLLER_REINFORCED, variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_ROTORBEARING_REINFORCED, "bearing", variant, true, new String[0]);
        this.genShaft((Supplier<? extends Block>)Content.Blocks.TURBINE_ROTORSHAFT_REINFORCED, "rotorshaft", variant);
        this.genBlade((Supplier<? extends Block>)Content.Blocks.TURBINE_ROTORBLADE_REINFORCED, "rotorblade", variant);
        this.genRedstonePort((Supplier<? extends Block>)Content.Blocks.TURBINE_REDSTONEPORT_REINFORCED, variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED, "powertap_fe_active", variant, true, new String[0]);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_POWERTAP_FE_PASSIVE_REINFORCED, "powertap_fe_passive", variant, true, new String[0]);
        this.genFluidPort((Supplier<? extends Block>)Content.Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED, "fluidport_forge_active", variant);
        this.genFluidPort((Supplier<? extends Block>)Content.Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED, "fluidport_forge_passive", variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_REINFORCED, "creative_steam_generator", variant, true, new String[0]);
        this.genComputerPort((Supplier<? extends Block>)Content.Blocks.TURBINE_COMPUTERPORT_REINFORCED, variant);
        this.genericPart((Supplier<? extends Block>)Content.Blocks.TURBINE_CHARGINGPORT_FE_REINFORCED, "charging", variant, true, new String[0]);
    }

    protected void genShaft(Supplier<? extends Block> block, String resourceName, String subFolder) {
        this.genShaft(block.get(), resourceName, subFolder);
    }

    protected void genShaft(Block block, String resourceName, String subFolder) {
        ResourceLocation texture0 = this.modLoc(TurbineBlockStateGenerator.fullResourceName((String)resourceName, (String)subFolder));
        ResourceLocation texture1 = this.modLoc(TurbineBlockStateGenerator.fullResourceName((String)resourceName, (String)subFolder));
        BlockModelProvider mbp = this.models();
        ModelBuilder z0c = ((BlockModelBuilder)((BlockModelBuilder)mbp.withExistingParent(TurbineBlockStateGenerator.fullResourceName((String)(resourceName + "_z_0c"), (String)subFolder), this.ROTOR_SHAFT_Z_0C_ID)).texture("0", texture0)).texture("1", texture1);
        ModelBuilder z2c = ((BlockModelBuilder)((BlockModelBuilder)mbp.withExistingParent(TurbineBlockStateGenerator.fullResourceName((String)(resourceName + "_z_2c"), (String)subFolder), this.ROTOR_SHAFT_Z_2C_ID)).texture("0", texture0)).texture("1", texture1);
        ModelBuilder z2cy = ((BlockModelBuilder)((BlockModelBuilder)mbp.withExistingParent(TurbineBlockStateGenerator.fullResourceName((String)(resourceName + "_z_2cy"), (String)subFolder), this.ROTOR_SHAFT_Z_2CY_ID)).texture("0", texture0)).texture("1", texture1);
        ModelBuilder z4c = ((BlockModelBuilder)((BlockModelBuilder)mbp.withExistingParent(TurbineBlockStateGenerator.fullResourceName((String)(resourceName + "_z_4c"), (String)subFolder), this.ROTOR_SHAFT_Z_4C_ID)).texture("0", texture0)).texture("1", texture1);
        ((ItemModelBuilder)this.itemModels().getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)z4c);
        this.genShaftVariant(block, RotorShaftState.HIDDEN, this.TRANSPARENT_BLOCK_MODEL, 0, 0);
        this.genShaftVariant(block, RotorShaftState.Y_NOBLADES, (ModelFile)z0c, -90, 0);
        this.genShaftVariant(block, RotorShaftState.Y_X, (ModelFile)z2c, -90, 0);
        this.genShaftVariant(block, RotorShaftState.Y_Z, (ModelFile)z2c, -90, 90);
        this.genShaftVariant(block, RotorShaftState.Y_XZ, (ModelFile)z4c, -90, 0);
        this.genShaftVariant(block, RotorShaftState.X_NOBLADES, (ModelFile)z0c, 0, -90);
        this.genShaftVariant(block, RotorShaftState.X_Y, (ModelFile)z2cy, 0, 90);
        this.genShaftVariant(block, RotorShaftState.X_Z, (ModelFile)z2c, 0, -90);
        this.genShaftVariant(block, RotorShaftState.X_YZ, (ModelFile)z4c, 0, -90);
        this.genShaftVariant(block, RotorShaftState.Z_NOBLADES, (ModelFile)z0c, 0, 0);
        this.genShaftVariant(block, RotorShaftState.Z_Y, (ModelFile)z2cy, 0, 0);
        this.genShaftVariant(block, RotorShaftState.Z_X, (ModelFile)z2c, 0, 0);
        this.genShaftVariant(block, RotorShaftState.Z_XY, (ModelFile)z4c, 0, 0);
    }

    protected void genBlade(Supplier<? extends Block> block, String resourceName, String subFolder) {
        this.genBlade(block.get(), resourceName, subFolder);
    }

    protected void genBlade(Block block, String resourceName, String subFolder) {
        ResourceLocation textureId0 = this.modLoc(TurbineBlockStateGenerator.fullResourceName((String)resourceName, (String)subFolder));
        ResourceLocation textureId1 = this.modLoc(TurbineBlockStateGenerator.fullResourceName((String)resourceName, (String)subFolder));
        BlockModelProvider mbp = this.models();
        ModelBuilder z = ((BlockModelBuilder)((BlockModelBuilder)mbp.withExistingParent(TurbineBlockStateGenerator.fullResourceName((String)(resourceName + "_z"), (String)subFolder), this.ROTOR_BLADE_Z_ID)).texture("0", textureId0)).texture("1", textureId1);
        ModelBuilder zy = ((BlockModelBuilder)((BlockModelBuilder)mbp.withExistingParent(TurbineBlockStateGenerator.fullResourceName((String)(resourceName + "_zy"), (String)subFolder), this.ROTOR_BLADE_ZY_ID)).texture("0", textureId0)).texture("1", textureId1);
        this.simpleBlockItem(block, (ModelFile)z);
        this.genBladeVariant(block, RotorBladeState.HIDDEN, this.TRANSPARENT_BLOCK_MODEL, 0, 0);
        this.genBladeVariant(block, RotorBladeState.Y_X_POS, (ModelFile)z, 90, 0);
        this.genBladeVariant(block, RotorBladeState.Y_X_NEG, (ModelFile)z, -90, 180);
        this.genBladeVariant(block, RotorBladeState.Y_Z_POS, (ModelFile)z, 90, 90);
        this.genBladeVariant(block, RotorBladeState.Y_Z_NEG, (ModelFile)z, -90, -90);
        this.genBladeVariant(block, RotorBladeState.X_Y_POS, (ModelFile)zy, 0, 90);
        this.genBladeVariant(block, RotorBladeState.X_Y_NEG, (ModelFile)zy, -180, -90);
        this.genBladeVariant(block, RotorBladeState.X_Z_POS, (ModelFile)z, 0, 90);
        this.genBladeVariant(block, RotorBladeState.X_Z_NEG, (ModelFile)z, 0, -90);
        this.genBladeVariant(block, RotorBladeState.Z_Y_POS, (ModelFile)zy, 0, 180);
        this.genBladeVariant(block, RotorBladeState.Z_Y_NEG, (ModelFile)zy, 180, 0);
        this.genBladeVariant(block, RotorBladeState.Z_X_POS, (ModelFile)z, 180, 0);
        this.genBladeVariant(block, RotorBladeState.Z_X_NEG, (ModelFile)z, 180, 180);
    }

    private void genShaftVariant(Block block, RotorShaftState state, ModelFile model, int rotateX, int rotateY) {
        this.genPropertyVariant(block, TurbineRotorComponentBlock.ROTOR_SHAFT_STATE, state, model, rotateX, rotateY, false);
    }

    private void genBladeVariant(Block block, RotorBladeState state, ModelFile model, int rotateX, int rotateY) {
        this.genPropertyVariant(block, TurbineRotorComponentBlock.ROTOR_BLADE_STATE, state, model, rotateX, rotateY, false);
    }

    protected static String fullResourceName(String resourceName) {
        return "block/turbine/" + resourceName;
    }
}

