/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.SourceTag;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.tag.CollectionProviders;
import it.zerono.mods.zerocore.lib.tag.TagList;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="bigreactors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ReactantMappingsRegistry {
    public static final int STANDARD_SOLID_REACTANT_AMOUNT = 1000;
    public static final int STANDARD_FLUID_REACTANT_AMOUNT = 1;
    private static final Map<ResourceLocation, IMapping<ResourceLocation, Reactant>> s_solidToReactant = Maps.newHashMap();
    private static final Map<Reactant, List<IMapping<Reactant, ResourceLocation>>> s_reactantToSolid = Maps.newHashMap();
    private static final TagList<Item> s_solidTags = new TagList(CollectionProviders.ITEMS_PROVIDER);
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/ReactantMappingsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});
    private static final ITextComponent TOOLTIP_FUEL_SOURCE = new TranslationTextComponent("api.bigreactors.reactor.tooltip.reactant.fuel").func_230530_a_(ExtremeReactorsAPI.STYLE_TOOLTIP);

    public static Optional<IMapping<ResourceLocation, Reactant>> getFromSolid(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        Item item = stack.func_77973_b();
        return s_solidTags.find(tag -> tag.func_230235_a_((Object)item)).filter(t -> t instanceof ITag.INamedTag).map(t -> (ITag.INamedTag)t).map(ITag.INamedTag::func_230234_a_).map(s_solidToReactant::get);
    }

    public static Optional<List<IMapping<Reactant, ResourceLocation>>> getToSolid(Reactant reactant) {
        return Optional.ofNullable(s_reactantToSolid.get(reactant));
    }

    public static ItemStack getSolidStackFrom(IMapping<Reactant, ResourceLocation> mapping, int amount) {
        return s_solidTags.getTag(mapping.getProduct()).map(TagsHelper::getTagFirstElement).map(item -> ItemHelper.stackFrom((IItemProvider)item, (int)amount)).orElse(ItemStack.field_190927_a);
    }

    @Deprecated
    public static void register(String reactantName, int reactantQty, ResourceLocation sourceItemTagId) {
        ReactantMappingsRegistry.registerSolid(reactantName, reactantQty, sourceItemTagId);
    }

    public static void registerSolid(String reactantName, int reactantQty, ResourceLocation sourceItemTagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)reactantName) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)sourceItemTagId);
        InternalDispatcher.dispatch("mapping-register", () -> {
            int qty;
            if (reactantQty < 0) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Using default quantity for reactant {} instead of the provided, invalid, one: {}", (Object)reactantName, (Object)reactantQty);
                qty = 1000;
            } else {
                qty = reactantQty;
            }
            CodeHelper.optionalIfPresentOrElse(ReactantsRegistry.get(reactantName), reactant -> {
                IMapping<ResourceLocation, Reactant> mapping = IMapping.of(sourceItemTagId, 1, reactant, qty);
                s_solidToReactant.put(mapping.getSource(), mapping);
                s_reactantToSolid.computeIfAbsent(mapping.getProduct(), k -> Lists.newArrayList()).add(mapping.getReverse());
            }, () -> ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source reactant: {}", (Object)reactantName));
        });
    }

    public static void removeSolid(String sourceItemTagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceItemTagId) ? 1 : 0) != 0);
        ReactantMappingsRegistry.removeSolid(new ResourceLocation(sourceItemTagId));
    }

    public static void removeSolid(ResourceLocation sourceItemTagId) {
        Preconditions.checkNotNull((Object)sourceItemTagId);
        InternalDispatcher.dispatch("mapping-remove", () -> {
            IMapping<ResourceLocation, Reactant> removedMapping = s_solidToReactant.remove(sourceItemTagId);
            if (null != removedMapping) {
                s_reactantToSolid.getOrDefault(removedMapping.getProduct(), Collections.emptyList()).removeIf(reactantToTagMapping -> ((ResourceLocation)reactantToTagMapping.getProduct()).equals((Object)sourceItemTagId));
                s_reactantToSolid.entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet()).forEach(s_reactantToSolid::remove);
            }
        });
    }

    public static void fillReactantsTooltips(Map<Item, Set<ITextComponent>> tooltipsMap, NonNullSupplier<Set<ITextComponent>> setSupplier) {
        s_solidToReactant.values().stream().filter(mapping -> ((Reactant)mapping.getProduct()).getType().isFuel()).map(IMapping::getSource).forEach(id -> s_solidTags.forTag(id, tag -> tag.func_230236_b_().forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_FUEL_SOURCE))));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onVanillaTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
        ReactantMappingsRegistry.updateTags(s_solidToReactant.keySet(), s_solidTags, TagsHelper.ITEMS);
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        ReactantMappingsRegistry.processWrapper("solid", wrapper.ReactorReactantSources, s_solidToReactant, s_reactantToSolid, ReactantMappingsRegistry::removeSolid, w -> ReactantMappingsRegistry.registerSolid(w.ProductName, w.ProductQuantity, new ResourceLocation(w.SourceTagId)));
    }

    private ReactantMappingsRegistry() {
    }

    private static <T> void updateTags(Set<ResourceLocation> ids, TagList<T> tagList, TagsHelper<T> helper) {
        tagList.clear();
        ids.stream().filter(arg_0 -> helper.tagExist(arg_0)).map(arg_0 -> helper.createTag(arg_0)).forEach(arg_0 -> tagList.addTag(arg_0));
    }

    private static <X> void processWrapper(String objectName, AddRemoveSection<SourceTag> wrapperSection, Map<ResourceLocation, IMapping<ResourceLocation, Reactant>> sourceToReactant, Map<Reactant, List<IMapping<Reactant, ResourceLocation>>> reactantToSources, Consumer<String> removeAction, Consumer<SourceTag> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} Reactor Reactant source mappings", (Object)objectName);
            sourceToReactant.clear();
            reactantToSources.clear();
        } else {
            Arrays.stream(wrapperSection.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        Arrays.stream(wrapperSection.Add).filter(Objects::nonNull).forEach(addAction);
    }
}

