/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WallFrameBlock
extends WallBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    private final Map<BlockState, VoxelShape> stateToShapeMap;
    private final Map<BlockState, VoxelShape> stateToCollisionShapeMap;

    public WallFrameBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false)));
        this.stateToShapeMap = this.func_235624_a_(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.stateToCollisionShapeMap = this.func_235624_a_(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape func_235631_a_(VoxelShape p_235631_0_, WallHeight p_235631_1_, VoxelShape p_235631_2_, VoxelShape p_235631_3_) {
        if (p_235631_1_ == WallHeight.TALL) {
            return VoxelShapes.func_197872_a((VoxelShape)p_235631_0_, (VoxelShape)p_235631_3_);
        }
        return p_235631_1_ == WallHeight.LOW ? VoxelShapes.func_197872_a((VoxelShape)p_235631_0_, (VoxelShape)p_235631_2_) : p_235631_0_;
    }

    private Map<BlockState, VoxelShape> func_235624_a_(float p_235624_1_, float p_235624_2_, float p_235624_3_, float p_235624_4_, float p_235624_5_, float p_235624_6_) {
        float f = 8.0f - p_235624_1_;
        float f1 = 8.0f + p_235624_1_;
        float f2 = 8.0f - p_235624_2_;
        float f3 = 8.0f + p_235624_2_;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)p_235624_3_, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_5_, (double)f3);
        VoxelShape voxelshape5 = Block.func_208617_a((double)f2, (double)p_235624_4_, (double)0.0, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape6 = Block.func_208617_a((double)f2, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)16.0);
        VoxelShape voxelshape7 = Block.func_208617_a((double)0.0, (double)p_235624_4_, (double)f2, (double)f3, (double)p_235624_6_, (double)f3);
        VoxelShape voxelshape8 = Block.func_208617_a((double)f2, (double)p_235624_4_, (double)f2, (double)16.0, (double)p_235624_6_, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int lightlevel = 0; lightlevel < 16; ++lightlevel) {
            for (Boolean obool : field_176256_a.func_177700_c()) {
                for (WallHeight wallheight : field_235612_b_.func_177700_c()) {
                    for (WallHeight wallheight1 : field_235613_c_.func_177700_c()) {
                        for (WallHeight wallheight2 : field_235615_e_.func_177700_c()) {
                            for (WallHeight wallheight3 : field_235614_d_.func_177700_c()) {
                                VoxelShape voxelshape9 = VoxelShapes.func_197880_a();
                                voxelshape9 = WallFrameBlock.func_235631_a_(voxelshape9, wallheight, voxelshape4, voxelshape8);
                                voxelshape9 = WallFrameBlock.func_235631_a_(voxelshape9, wallheight2, voxelshape3, voxelshape7);
                                voxelshape9 = WallFrameBlock.func_235631_a_(voxelshape9, wallheight1, voxelshape1, voxelshape5);
                                voxelshape9 = WallFrameBlock.func_235631_a_(voxelshape9, wallheight3, voxelshape2, voxelshape6);
                                if (obool.booleanValue()) {
                                    voxelshape9 = VoxelShapes.func_197872_a((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                                }
                                BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176256_a, (Comparable)obool)).func_206870_a((Property)field_235612_b_, (Comparable)wallheight)).func_206870_a((Property)field_235615_e_, (Comparable)wallheight2)).func_206870_a((Property)field_235613_c_, (Comparable)wallheight1)).func_206870_a((Property)field_235614_d_, (Comparable)wallheight3);
                                builder.put(((BlockState)((BlockState)blockstate.func_206870_a((Property)field_235616_f_, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightlevel)), (Object)voxelshape9);
                                builder.put(((BlockState)((BlockState)blockstate.func_206870_a((Property)field_235616_f_, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightlevel)), (Object)voxelshape9);
                                builder.put(((BlockState)((BlockState)blockstate.func_206870_a((Property)field_235616_f_, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightlevel)), (Object)voxelshape9);
                                builder.put(((BlockState)((BlockState)blockstate.func_206870_a((Property)field_235616_f_, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightlevel)), (Object)voxelshape9);
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176256_a, field_235613_c_, field_235612_b_, field_235615_e_, field_235614_d_, field_235616_f_, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.stateToCollisionShapeMap.get(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FrameBlockTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            BlockAppearanceHelper.setRotation(world, pos, player, item);
            if (item.func_77973_b() instanceof BlockItem) {
                if (((Boolean)state.func_177229_b((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof FrameBlockTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        FrameBlockTile frameTileEntity;
        BlockState blockState;
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof FrameBlockTile && (blockState = (frameTileEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            worldIn.func_217379_c(1010, pos, 0);
            frameTileEntity.clear();
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            frameTileEntity.clear();
        }
    }

    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FrameBlockTile) {
            FrameBlockTile frameTileEntity = (FrameBlockTile)tileentity;
            frameTileEntity.clear();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }
}

