/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameTileEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChestFrameBlock
extends FrameBlock
implements IWaterLoggable {
    private static final VoxelShape INNER_CUBE = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape BOTTOM_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
    private static final VoxelShape BOTTOM_EAST = Block.func_208617_a((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0);
    private static final VoxelShape BOTTOM_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape BOTTOM_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0);
    private static final VoxelShape TOP_NORTH = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape TOP_EAST = Block.func_208617_a((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape TOP_SOUTH = Block.func_208617_a((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_WEST = Block.func_208617_a((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0);
    private static final VoxelShape NW_PILLAR = Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0);
    private static final VoxelShape SW_PILLAR = Block.func_208617_a((double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0);
    private static final VoxelShape NE_PILLAR = Block.func_208617_a((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    private static final VoxelShape SE_PILLAR = Block.func_208617_a((double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape CHEST = VoxelShapes.func_216384_a((VoxelShape)INNER_CUBE, (VoxelShape[])new VoxelShape[]{BOTTOM_EAST, BOTTOM_SOUTH, BOTTOM_WEST, BOTTOM_NORTH, TOP_EAST, TOP_SOUTH, TOP_WEST, TOP_NORTH, NW_PILLAR, SW_PILLAR, NE_PILLAR, SE_PILLAR});

    public ChestFrameBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y, BlockStateProperties.field_208157_J, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        if (fluidstate.func_206886_c() == Fluids.field_204546_a) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206889_d()));
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)Registration.CHEST_FRAME_TILE.get()).func_200968_a();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof ChestFrameTileEntity) {
            ((ChestFrameTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (item.func_77973_b() instanceof BlockItem) {
                if (Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof ChestFrameTileEntity && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setRotation(world, pos, player, item);
            if (tileEntity instanceof ChestFrameTileEntity && ((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue() && !Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((ChestFrameTileEntity)tileEntity), (BlockPos)pos);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        ChestFrameTileEntity frameTileEntity;
        BlockState blockState;
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof ChestFrameTileEntity && (blockState = (frameTileEntity = (ChestFrameTileEntity)tileentity).getMimic()) != null) {
            worldIn.func_217379_c(1010, pos, 0);
            frameTileEntity.func_174888_l();
            float f = 0.7f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
            ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
            itementity.func_174869_p();
            worldIn.func_217376_c((Entity)itementity);
            frameTileEntity.func_174888_l();
        }
    }

    @Override
    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ChestFrameTileEntity) {
            ChestFrameTileEntity frameTileEntity = (ChestFrameTileEntity)tileentity;
            frameTileEntity.func_174888_l();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof ChestFrameTileEntity) {
            this.dropContainedBlock(worldIn, pos);
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((ChestFrameTileEntity)te).func_190576_q());
        }
    }

    @Override
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return CHEST;
    }
}

