/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.trunkplacer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import quek.undergarden.registry.UGTrunkPlacerTypes;

public class SmogstemTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<SmogstemTrunkPlacer> CODEC = RecordCodecBuilder.create(me -> SmogstemTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)me).apply((Applicative)me, SmogstemTrunkPlacer::new));

    public SmogstemTrunkPlacer(int baseHeight, int firstRandHeight, int secondRandHeight) {
        super(baseHeight, firstRandHeight, secondRandHeight);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return UGTrunkPlacerTypes.SMOGSTEM_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int yMaybe, BlockPos pos, Set<BlockPos> posSet, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config) {
        IBlockReader reader = (IBlockReader)world;
        int treeBaseHeight = config.field_236678_g_.func_236917_a_(rand);
        int j = treeBaseHeight / 8 + rand.nextInt(2);
        for (int k = 0; k < treeBaseHeight; ++k) {
            float thiccness = (1.0f - (float)k / (float)treeBaseHeight) * (float)j;
            int l = MathHelper.func_76123_f((float)treeBaseHeight);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)MathHelper.func_76130_a((int)i1) - 0.25f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)MathHelper.func_76130_a((int)j1) - 0.25f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > thiccness * thiccness || (i1 == -l || i1 == l || j1 == -l || j1 == l) && rand.nextFloat() > 0.75f) continue;
                    BlockState blockstate = reader.func_180495_p(pos.func_177982_a(i1, k, j1));
                    if (blockstate.isAir((IBlockReader)world, pos)) {
                        SmogstemTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)pos.func_177982_a(i1, k, j1), posSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)config);
                    }
                    if (k == 0 || l <= 1 || !(blockstate = reader.func_180495_p(pos.func_177982_a(i1, -k, j1))).isAir((IBlockReader)world, pos)) continue;
                    SmogstemTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)pos.func_177982_a(i1, k, j1), posSet, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)config);
                }
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.Foliage(pos.func_177981_b(treeBaseHeight), 0, false));
    }
}

