/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.stoneborn;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.stoneborn.goals.StonebornLookAtCustomerGoal;
import quek.undergarden.entity.stoneborn.goals.StonebornTradeWithPlayerGoal;
import quek.undergarden.entity.stoneborn.trading.StonebornTrades;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class StonebornEntity
extends MonsterEntity
implements IAngerable,
INPC,
IMerchant {
    protected int timeOutOfUG = 0;
    private static final RangedInteger ANGER_TIME_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID targetUuid;
    @Nullable
    private PlayerEntity customer;
    @Nullable
    protected MerchantOffers offers;

    public StonebornEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new StonebornTradeWithPlayerGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StonebornLookAtCustomerGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.3));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 32.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 0.9);
    }

    public static boolean canStonebornSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && randomIn.nextInt(10) == 0 && StonebornEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_213398_dR()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_ANGRY.get();
        }
        if (this.hasCustomer()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_SPEAKING.get();
        }
        if (!this.inUndergarden()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.STONEBORN_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UGSoundEvents.STONEBORN_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)UGSoundEvents.STONEBORN_STEP.get(), 1.0f, 1.0f);
    }

    protected SoundEvent getYesOrNoSound(boolean getYesSound) {
        return getYesSound ? (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get() : (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand playerHand) {
        ItemStack itemstack = player.func_184586_b(playerHand);
        if (itemstack.func_77973_b() != UGItems.STONEBORN_SPAWN_EGG.get() && this.func_70089_S() && !this.hasCustomer() && this.inUndergarden()) {
            if (this.func_213706_dY().isEmpty()) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, playerHand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.inUndergarden()) {
            ++this.timeOutOfUG;
            this.func_195064_c(new EffectInstance(Effects.field_76431_k, 300, 0));
        } else {
            this.timeOutOfUG = 0;
        }
        if (this.timeOutOfUG > 300) {
            this.func_184185_a((SoundEvent)UGSoundEvents.STONEBORN_CHANT.get(), 1.0f, 1.0f);
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                Explosion.Mode explosionType = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
                this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, explosionType);
            }
        }
        if (!this.func_213398_dR() && this.field_70170_p.func_82737_E() % 40L == 0L) {
            this.func_70691_i(1.0f);
        }
    }

    public boolean inUndergarden() {
        return this.field_70170_p.func_234923_W_() == UGDimensions.UNDERGARDEN_WORLD && !this.func_175446_cd();
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.timeOutOfUG = nbt.func_74762_e("TimeOutOfUndergarden");
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        nbt.func_74768_a("TimeOutOfUndergarden", this.timeOutOfUG);
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.targetUuid;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.targetUuid = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_TIME_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.customer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected void populateTradeData() {
        VillagerTrades.ITrade[] trades = (VillagerTrades.ITrade[])StonebornTrades.STONEBORN_TRADES.get(1);
        if (trades != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.addTrades(merchantoffers, trades, 4);
        }
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.onStonebornTrade(offer);
        if (this.customer instanceof ServerPlayerEntity) {
            UGCriteria.STONEBORN_TRADE.test((ServerPlayerEntity)this.customer, this, offer.func_222200_d());
        }
    }

    protected void onStonebornTrade(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getYesOrNoSound(!stack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_213702_q(int xpIn) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public SoundEvent func_213714_ea() {
        return (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get();
    }
}

