/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import quek.undergarden.block.UGBushBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;

public class DitchbulbBlock
extends UGBushBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_222512_Y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public DitchbulbBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)UGItems.DITCHBULB.get());
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (rand.nextInt(10) == 0 && age != 1 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean maxAge;
        int age = (Integer)state.func_177229_b((Property)AGE);
        boolean bl = maxAge = age == 1;
        if (!maxAge && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (maxAge) {
            DitchbulbBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)UGItems.DITCHBULB.get(), 1));
            worldIn.func_184133_a(null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    @Override
    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block != UGBlocks.DEEPTURF_BLOCK.get() && block != UGBlocks.DEEPSOIL.get() && block != UGBlocks.DEPTHROCK.get()) {
            return worldIn.func_226659_b_(pos, 0) < 0 && blockstate.canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.8;
        double z = (double)pos.func_177952_p() + 0.5;
        if ((Integer)stateIn.func_177229_b((Property)AGE) == 1) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) < 1;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
    }
}

