/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.slurry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.slurry.SlurryChannelSettings;
import terrails.xnetgases.module.slurry.SlurryConnectorSettings;

public class SlurryUtils {
    private static Map<String, SlurryConnectorSettings.SlurryMode> connectorModeCache;
    private static Map<String, SlurryChannelSettings.ChannelMode> channelModeCache;

    @Nonnull
    public static SlurryConnectorSettings.SlurryMode getConnectorModeFrom(String s) {
        if (connectorModeCache == null) {
            connectorModeCache = new HashMap<String, SlurryConnectorSettings.SlurryMode>();
            for (SlurryConnectorSettings.SlurryMode mode : SlurryConnectorSettings.SlurryMode.values()) {
                connectorModeCache.put(mode.name(), mode);
            }
        }
        return connectorModeCache.get(s);
    }

    @Nonnull
    public static SlurryChannelSettings.ChannelMode getChannelModeFrom(String s) {
        if (channelModeCache == null) {
            channelModeCache = new HashMap<String, SlurryChannelSettings.ChannelMode>();
            for (SlurryChannelSettings.ChannelMode mode : SlurryChannelSettings.ChannelMode.values()) {
                channelModeCache.put(mode.name(), mode);
            }
        }
        return channelModeCache.get(s);
    }

    @Nonnull
    public static Optional<ISlurryHandler> getSlurryHandlerFor(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.SLURRY_HANDLER_CAPABILITY != null && provider.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY, direction).isPresent()) {
            return Optional.of(provider.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY, direction).orElseThrow(() -> new IllegalArgumentException("ISlurryHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof ISlurryHandler.ISidedSlurryHandler && ((ISlurryHandler.ISidedSlurryHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((ISlurryHandler)provider);
        }
        if (!(provider instanceof ISlurryHandler.ISidedSlurryHandler) && provider instanceof ISlurryHandler && ((ISlurryHandler)provider).getTanks() >= 1) {
            return Optional.of((ISlurryHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static SlurryStack insertSlurry(ISlurryHandler handler, SlurryStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            return (SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (SlurryStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static SlurryStack extractSlurry(ISlurryHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            return (SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).extractChemical(amount, direction, action);
        }
        return (SlurryStack)handler.extractChemical(amount, action);
    }

    public static List<Slurry> getSlurryInTank(@Nonnull ISlurryHandler handler, @Nullable Direction direction) {
        ArrayList<Slurry> slurries = new ArrayList<Slurry>();
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            for (int i = 0; i < ((ISlurryHandler.ISidedSlurryHandler)handler).getTanks(direction); ++i) {
                slurries.add((Slurry)((SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).getChemicalInTank(i, direction)).getType());
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                slurries.add((Slurry)((SlurryStack)handler.getChemicalInTank(i)).getType());
            }
        }
        return slurries;
    }

    public static List<Slurry> getSlurryInTank(@Nonnull ISlurryHandler handler) {
        return SlurryUtils.getSlurryInTank(handler, null);
    }

    public static long getSlurryCount(@Nonnull ISlurryHandler handler, @Nullable Direction direction, @Nullable Predicate<SlurryStack> filter) {
        long count = 0L;
        if (handler instanceof ISlurryHandler.ISidedSlurryHandler) {
            for (int i = 0; i < ((ISlurryHandler.ISidedSlurryHandler)handler).getTanks(direction); ++i) {
                SlurryStack stack = (SlurryStack)((ISlurryHandler.ISidedSlurryHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                SlurryStack stack = (SlurryStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long getSlurryCount(@Nonnull ISlurryHandler handler, @Nullable Direction direction, @Nullable Slurry filter) {
        return SlurryUtils.getSlurryCount(handler, direction, (SlurryStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long getSlurryCount(@Nonnull ISlurryHandler handler, @Nullable Direction direction, @Nullable SlurryStack filter) {
        return SlurryUtils.getSlurryCount(handler, direction, (SlurryStack stack) -> filter == null || stack.equals((Object)filter));
    }

    public static long getSlurryCount(@Nonnull ISlurryHandler handler, @Nullable Direction direction) {
        return SlurryUtils.getSlurryCount(handler, direction, (Predicate<SlurryStack>)null);
    }

    public static long getSlurryCount(@Nonnull ISlurryHandler handler) {
        return SlurryUtils.getSlurryCount(handler, null);
    }
}

