/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.slurry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.setup.Config;
import mekanism.api.Action;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.ChemicalChannelSettings;
import terrails.xnetgases.module.slurry.SlurryConnectorSettings;
import terrails.xnetgases.module.slurry.SlurryUtils;

public class SlurryChannelSettings
extends ChemicalChannelSettings {
    private ChannelMode channelMode = ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private List<Pair<SidedConsumer, SlurryConnectorSettings>> slurryExtractors;
    private List<Pair<SidedConsumer, SlurryConnectorSettings>> slurryConsumers;

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = SlurryUtils.getChannelModeFrom(data.get("mode").getAsString());
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.channelMode = ChannelMode.values()[nbt.func_74771_c("mode")];
        this.delay = nbt.func_74762_e("delay");
        this.roundRobinOffset = nbt.func_74762_e("offset");
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74774_a("mode", (byte)this.channelMode.ordinal());
        nbt.func_74768_a("delay", this.delay);
        nbt.func_74768_a("offset", this.roundRobinOffset);
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 == 0) {
            int d = this.delay / 10;
            this.updateCache(channel, context);
            World world = context.getControllerWorld();
            block0: for (Pair<SidedConsumer, SlurryConnectorSettings> entry : this.slurryExtractors) {
                SlurryStack stack;
                TileEntity te;
                Optional<ISlurryHandler> optional;
                BlockPos pos;
                BlockPos extractorPos;
                SidedConsumer consumer = (SidedConsumer)entry.getFirst();
                SlurryConnectorSettings settings = (SlurryConnectorSettings)((Object)entry.getSecond());
                if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(consumer.getConsumerId())) == null || !LevelTools.isLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(consumer.getSide()))) || !(optional = SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)(te = world.func_175625_s(pos)), settings.getFacing())).isPresent()) continue;
                ISlurryHandler handler = optional.get();
                if (this.checkRedstone(world, settings, extractorPos)) {
                    return;
                }
                if (!context.matchColor(settings.getColorsMask())) {
                    return;
                }
                SlurryStack extractMatcher = settings.getMatcher();
                long toExtract = settings.getRate().intValue();
                Integer count = settings.getMinmax();
                if (count != null) {
                    long amount = SlurryUtils.getSlurryCount(handler, settings.getFacing(), extractMatcher);
                    long canExtract = amount - (long)count.intValue();
                    if (canExtract <= 0L) continue;
                    toExtract = Math.min(toExtract, canExtract);
                }
                if (this.channelMode == ChannelMode.PRIORITY && this.slurryExtractors.stream().anyMatch(_entry -> {
                    SidedConsumer _consumer = (SidedConsumer)_entry.getFirst();
                    SlurryConnectorSettings _settings = (SlurryConnectorSettings)((Object)((Object)_entry.getSecond()));
                    if (_settings.getPriority() <= settings.getPriority()) {
                        return false;
                    }
                    BlockPos _extractorPos = context.findConsumerPosition(_consumer.getConsumerId());
                    if (_extractorPos == null) {
                        return false;
                    }
                    BlockPos _pos = _extractorPos.func_177972_a(_consumer.getSide());
                    if (!LevelTools.isLoaded((World)world, (BlockPos)_pos)) {
                        return false;
                    }
                    Optional<ISlurryHandler> _optional = SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)world.func_175625_s(_pos), _settings.getFacing());
                    if (_optional.isPresent()) {
                        List<Slurry> _handlerSlurries;
                        ISlurryHandler _handler = _optional.get();
                        List<Slurry> handlerSlurries = SlurryUtils.getSlurryInTank(handler, consumer.getSide());
                        if (Collections.disjoint(handlerSlurries, _handlerSlurries = SlurryUtils.getSlurryInTank(_handler, _consumer.getSide()))) {
                            return false;
                        }
                        SlurryStack matcher = settings.getMatcher();
                        SlurryStack _matcher = _settings.getMatcher();
                        return !(matcher != null && !handlerSlurries.contains(matcher.getType()) || _matcher != null && !_handlerSlurries.contains(_matcher.getType()));
                    }
                    return false;
                })) continue;
                ArrayList<Pair<SidedConsumer, SlurryConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, SlurryConnectorSettings>>();
                while (!(stack = SlurryUtils.extractSlurry(handler, toExtract, settings.getFacing(), Action.SIMULATE)).isEmpty() && (extractMatcher == null || extractMatcher.equals((Object)stack))) {
                    toExtract = stack.getAmount();
                    inserted.clear();
                    long remaining = this.insertSlurrySimulate(inserted, context, stack);
                    if (inserted.isEmpty() || (toExtract -= remaining) <= 0L) continue block0;
                    if (remaining > 0L) continue;
                    if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) continue block0;
                    stack = SlurryUtils.extractSlurry(handler, toExtract, settings.getFacing(), Action.EXECUTE);
                    if (stack.isEmpty()) {
                        throw new NullPointerException(handler.getClass().getName() + " misbehaved! handler.extractSlurry(" + toExtract + ", Action.SIMULATE) returned null, even though handler.extractSlurry(" + toExtract + ", Action.EXECUTE) did not");
                    }
                    this.insertSlurryReal(context, inserted, stack);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void cleanCache() {
        this.slurryExtractors = null;
        this.slurryConsumers = null;
    }

    private long insertSlurrySimulate(@Nonnull List<Pair<SidedConsumer, SlurryConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull SlurryStack stack) {
        World world = context.getControllerWorld();
        long amount = stack.getAmount();
        for (int j = 0; j < this.slurryConsumers.size(); ++j) {
            BlockPos pos;
            TileEntity te;
            Optional<ISlurryHandler> optional;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.slurryConsumers.size();
            Pair<SidedConsumer, SlurryConnectorSettings> entry = this.slurryConsumers.get(i);
            SidedConsumer consumer = (SidedConsumer)entry.getFirst();
            SlurryConnectorSettings settings = (SlurryConnectorSettings)((Object)entry.getSecond());
            if (settings.getMatcher() != null && !settings.getMatcher().equals((Object)stack) || (consumerPos = context.findConsumerPosition(consumer.getConsumerId())) == null || !LevelTools.isLoaded((World)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask()) || !(optional = SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)(te = world.func_175625_s(pos = consumerPos.func_177972_a(consumer.getSide()))), settings.getFacing())).isPresent()) continue;
            ISlurryHandler handler = optional.get();
            long toInsert = Math.min((long)settings.getRate().intValue(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                long a = SlurryUtils.getSlurryCount(handler, settings.getFacing(), settings.getMatcher());
                long canInsert = (long)count.intValue() - a;
                if (canInsert <= 0L) continue;
                toInsert = Math.min(toInsert, canInsert);
            }
            if (this.channelMode == ChannelMode.PRIORITY && this.slurryConsumers.stream().anyMatch(_entry -> {
                SidedConsumer _consumer = (SidedConsumer)_entry.getFirst();
                SlurryConnectorSettings _settings = (SlurryConnectorSettings)((Object)((Object)_entry.getSecond()));
                if (_settings.getPriority() <= settings.getPriority()) {
                    return false;
                }
                BlockPos _extractorPos = context.findConsumerPosition(_consumer.getConsumerId());
                if (_extractorPos == null) {
                    return false;
                }
                BlockPos _pos = _extractorPos.func_177972_a(_consumer.getSide());
                if (!LevelTools.isLoaded((World)world, (BlockPos)_pos)) {
                    return false;
                }
                Optional<ISlurryHandler> _optional = SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)world.func_175625_s(_pos), _settings.getFacing());
                if (_optional.isPresent()) {
                    List<Slurry> _handlerSlurries;
                    ISlurryHandler _handler = _optional.get();
                    List<Slurry> handlerSlurries = SlurryUtils.getSlurryInTank(handler, consumer.getSide());
                    if (Collections.disjoint(handlerSlurries, _handlerSlurries = SlurryUtils.getSlurryInTank(_handler, _consumer.getSide()))) {
                        return false;
                    }
                    SlurryStack matcher = settings.getMatcher();
                    SlurryStack _matcher = _settings.getMatcher();
                    return !(matcher != null && !handlerSlurries.contains(matcher.getType()) || _matcher != null && !_handlerSlurries.contains(_matcher.getType()));
                }
                return false;
            })) continue;
            SlurryStack copy = stack.copy();
            copy.setAmount(toInsert);
            SlurryStack remaining = SlurryUtils.insertSlurry(handler, copy, settings.getFacing(), Action.SIMULATE);
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            inserted.add(entry);
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return 0L;
        }
        return amount;
    }

    private void insertSlurryReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, SlurryConnectorSettings>> inserted, @Nonnull SlurryStack stack) {
        long amount = stack.getAmount();
        for (Pair<SidedConsumer, SlurryConnectorSettings> pair : inserted) {
            SlurryConnectorSettings settings = (SlurryConnectorSettings)((Object)pair.getSecond());
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)pair.getFirst()).getConsumerId());
            assert (consumerPosition != null);
            BlockPos pos = consumerPosition.func_177972_a(((SidedConsumer)pair.getFirst()).getSide());
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            Optional<ISlurryHandler> optional = SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)te, settings.getFacing());
            if (!optional.isPresent()) continue;
            ISlurryHandler handler = optional.get();
            long toInsert = Math.min((long)settings.getRate().intValue(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                long a = SlurryUtils.getSlurryCount(handler, settings.getFacing(), settings.getMatcher());
                long caninsert = (long)count.intValue() - a;
                if (caninsert <= 0L) continue;
                toInsert = Math.min(toInsert, caninsert);
            }
            SlurryStack copy = stack.copy();
            copy.setAmount(toInsert);
            SlurryStack remaining = SlurryUtils.insertSlurry(handler, copy, settings.getFacing(), Action.EXECUTE);
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.slurryConsumers.size();
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return;
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.slurryExtractors == null) {
            SlurryConnectorSettings settings;
            SidedConsumer consumer;
            this.slurryExtractors = new ArrayList<Pair<SidedConsumer, SlurryConnectorSettings>>();
            this.slurryConsumers = new ArrayList<Pair<SidedConsumer, SlurryConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (SlurryConnectorSettings)((Object)entry.getValue());
                if (settings.getSlurryMode() == SlurryConnectorSettings.SlurryMode.EXT) {
                    this.slurryExtractors.add((Pair<SidedConsumer, SlurryConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
                    continue;
                }
                this.slurryConsumers.add((Pair<SidedConsumer, SlurryConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (SlurryConnectorSettings)((Object)entry.getValue());
                if (settings.getSlurryMode() != SlurryConnectorSettings.SlurryMode.INS) continue;
                this.slurryConsumers.add((Pair<SidedConsumer, SlurryConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
            }
            this.slurryConsumers.sort((o1, o2) -> ((SlurryConnectorSettings)((Object)((Object)o2.getSecond()))).getPriority().compareTo(((SlurryConnectorSettings)((Object)((Object)o1.getSecond()))).getPriority()));
        }
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 90, 11, 10);
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices("mode", "Slurry distribution mode", (Enum)this.channelMode, (Enum[])ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get("mode")).toUpperCase());
    }

    public static enum ChannelMode {
        PRIORITY,
        DISTRIBUTE;

    }
}

