/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.pigment;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.setup.Config;
import mekanism.api.Action;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.ChemicalChannelSettings;
import terrails.xnetgases.module.pigment.PigmentConnectorSettings;
import terrails.xnetgases.module.pigment.PigmentUtils;

public class PigmentChannelSettings
extends ChemicalChannelSettings {
    private ChannelMode channelMode = ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private List<Pair<SidedConsumer, PigmentConnectorSettings>> pigmentExtractors;
    private List<Pair<SidedConsumer, PigmentConnectorSettings>> pigmentConsumers;

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = PigmentUtils.getChannelModeFrom(data.get("mode").getAsString());
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.channelMode = ChannelMode.values()[nbt.func_74771_c("mode")];
        this.delay = nbt.func_74762_e("delay");
        this.roundRobinOffset = nbt.func_74762_e("offset");
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74774_a("mode", (byte)this.channelMode.ordinal());
        nbt.func_74768_a("delay", this.delay);
        nbt.func_74768_a("offset", this.roundRobinOffset);
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 == 0) {
            int d = this.delay / 10;
            this.updateCache(channel, context);
            World world = context.getControllerWorld();
            block0: for (Pair<SidedConsumer, PigmentConnectorSettings> entry : this.pigmentExtractors) {
                PigmentStack stack;
                TileEntity te;
                Optional<IPigmentHandler> optional;
                BlockPos pos;
                BlockPos extractorPos;
                SidedConsumer consumer = (SidedConsumer)entry.getFirst();
                PigmentConnectorSettings settings = (PigmentConnectorSettings)((Object)entry.getSecond());
                if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(consumer.getConsumerId())) == null || !LevelTools.isLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(consumer.getSide()))) || !(optional = PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)(te = world.func_175625_s(pos)), settings.getFacing())).isPresent()) continue;
                IPigmentHandler handler = optional.get();
                if (this.checkRedstone(world, settings, extractorPos)) {
                    return;
                }
                if (!context.matchColor(settings.getColorsMask())) {
                    return;
                }
                PigmentStack extractMatcher = settings.getMatcher();
                long toExtract = settings.getRate().intValue();
                Integer count = settings.getMinmax();
                if (count != null) {
                    long amount = PigmentUtils.getPigmentCount(handler, settings.getFacing(), extractMatcher);
                    long canExtract = amount - (long)count.intValue();
                    if (canExtract <= 0L) continue;
                    toExtract = Math.min(toExtract, canExtract);
                }
                if (this.channelMode == ChannelMode.PRIORITY && this.pigmentExtractors.stream().anyMatch(_entry -> {
                    SidedConsumer _consumer = (SidedConsumer)_entry.getFirst();
                    PigmentConnectorSettings _settings = (PigmentConnectorSettings)((Object)((Object)_entry.getSecond()));
                    if (_settings.getPriority() <= settings.getPriority()) {
                        return false;
                    }
                    BlockPos _extractorPos = context.findConsumerPosition(_consumer.getConsumerId());
                    if (_extractorPos == null) {
                        return false;
                    }
                    BlockPos _pos = _extractorPos.func_177972_a(_consumer.getSide());
                    if (!LevelTools.isLoaded((World)world, (BlockPos)_pos)) {
                        return false;
                    }
                    Optional<IPigmentHandler> _optional = PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)world.func_175625_s(_pos), _settings.getFacing());
                    if (_optional.isPresent()) {
                        List<Pigment> _handlerPigments;
                        IPigmentHandler _handler = _optional.get();
                        List<Pigment> handlerPigments = PigmentUtils.getPigmentInTank(handler, consumer.getSide());
                        if (Collections.disjoint(handlerPigments, _handlerPigments = PigmentUtils.getPigmentInTank(_handler, _consumer.getSide()))) {
                            return false;
                        }
                        PigmentStack matcher = settings.getMatcher();
                        PigmentStack _matcher = _settings.getMatcher();
                        return !(matcher != null && !handlerPigments.contains(matcher.getType()) || _matcher != null && !_handlerPigments.contains(_matcher.getType()));
                    }
                    return false;
                })) continue;
                ArrayList<Pair<SidedConsumer, PigmentConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, PigmentConnectorSettings>>();
                while (!(stack = PigmentUtils.extractPigment(handler, toExtract, settings.getFacing(), Action.SIMULATE)).isEmpty() && (extractMatcher == null || extractMatcher.equals((Object)stack))) {
                    toExtract = stack.getAmount();
                    inserted.clear();
                    long remaining = this.insertPigmentSimulate(inserted, context, stack);
                    if (inserted.isEmpty() || (toExtract -= remaining) <= 0L) continue block0;
                    if (remaining > 0L) continue;
                    if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) continue block0;
                    stack = PigmentUtils.extractPigment(handler, toExtract, settings.getFacing(), Action.EXECUTE);
                    if (stack.isEmpty()) {
                        throw new NullPointerException(handler.getClass().getName() + " misbehaved! handler.extractPigment(" + toExtract + ", Action.SIMULATE) returned null, even though handler.extractPigment(" + toExtract + ", Action.EXECUTE) did not");
                    }
                    this.insertPigmentReal(context, inserted, stack);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void cleanCache() {
        this.pigmentExtractors = null;
        this.pigmentConsumers = null;
    }

    private long insertPigmentSimulate(@Nonnull List<Pair<SidedConsumer, PigmentConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull PigmentStack stack) {
        World world = context.getControllerWorld();
        long amount = stack.getAmount();
        for (int j = 0; j < this.pigmentConsumers.size(); ++j) {
            BlockPos pos;
            TileEntity te;
            Optional<IPigmentHandler> optional;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.pigmentConsumers.size();
            Pair<SidedConsumer, PigmentConnectorSettings> entry = this.pigmentConsumers.get(i);
            SidedConsumer consumer = (SidedConsumer)entry.getFirst();
            PigmentConnectorSettings settings = (PigmentConnectorSettings)((Object)entry.getSecond());
            if (settings.getMatcher() != null && !settings.getMatcher().equals((Object)stack) || (consumerPos = context.findConsumerPosition(consumer.getConsumerId())) == null || !LevelTools.isLoaded((World)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask()) || !(optional = PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)(te = world.func_175625_s(pos = consumerPos.func_177972_a(consumer.getSide()))), settings.getFacing())).isPresent()) continue;
            IPigmentHandler handler = optional.get();
            long toInsert = Math.min((long)settings.getRate().intValue(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                long a = PigmentUtils.getPigmentCount(handler, settings.getFacing(), settings.getMatcher());
                long canInsert = (long)count.intValue() - a;
                if (canInsert <= 0L) continue;
                toInsert = Math.min(toInsert, canInsert);
            }
            if (this.channelMode == ChannelMode.PRIORITY && this.pigmentConsumers.stream().anyMatch(_entry -> {
                SidedConsumer _consumer = (SidedConsumer)_entry.getFirst();
                PigmentConnectorSettings _settings = (PigmentConnectorSettings)((Object)((Object)_entry.getSecond()));
                if (_settings.getPriority() <= settings.getPriority()) {
                    return false;
                }
                BlockPos _extractorPos = context.findConsumerPosition(_consumer.getConsumerId());
                if (_extractorPos == null) {
                    return false;
                }
                BlockPos _pos = _extractorPos.func_177972_a(_consumer.getSide());
                if (!LevelTools.isLoaded((World)world, (BlockPos)_pos)) {
                    return false;
                }
                Optional<IPigmentHandler> _optional = PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)world.func_175625_s(_pos), _settings.getFacing());
                if (_optional.isPresent()) {
                    List<Pigment> _handlerPigments;
                    IPigmentHandler _handler = _optional.get();
                    List<Pigment> handlerPigments = PigmentUtils.getPigmentInTank(handler, consumer.getSide());
                    if (Collections.disjoint(handlerPigments, _handlerPigments = PigmentUtils.getPigmentInTank(_handler, _consumer.getSide()))) {
                        return false;
                    }
                    PigmentStack matcher = settings.getMatcher();
                    PigmentStack _matcher = _settings.getMatcher();
                    return !(matcher != null && !handlerPigments.contains(matcher.getType()) || _matcher != null && !_handlerPigments.contains(_matcher.getType()));
                }
                return false;
            })) continue;
            PigmentStack copy = stack.copy();
            copy.setAmount(toInsert);
            PigmentStack remaining = PigmentUtils.insertPigment(handler, copy, settings.getFacing(), Action.SIMULATE);
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            inserted.add(entry);
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return 0L;
        }
        return amount;
    }

    private void insertPigmentReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, PigmentConnectorSettings>> inserted, @Nonnull PigmentStack stack) {
        long amount = stack.getAmount();
        for (Pair<SidedConsumer, PigmentConnectorSettings> pair : inserted) {
            PigmentConnectorSettings settings = (PigmentConnectorSettings)((Object)pair.getSecond());
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)pair.getFirst()).getConsumerId());
            assert (consumerPosition != null);
            BlockPos pos = consumerPosition.func_177972_a(((SidedConsumer)pair.getFirst()).getSide());
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            Optional<IPigmentHandler> optional = PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)te, settings.getFacing());
            if (!optional.isPresent()) continue;
            IPigmentHandler handler = optional.get();
            long toInsert = Math.min((long)settings.getRate().intValue(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                long a = PigmentUtils.getPigmentCount(handler, settings.getFacing(), settings.getMatcher());
                long caninsert = (long)count.intValue() - a;
                if (caninsert <= 0L) continue;
                toInsert = Math.min(toInsert, caninsert);
            }
            PigmentStack copy = stack.copy();
            copy.setAmount(toInsert);
            PigmentStack remaining = PigmentUtils.insertPigment(handler, copy, settings.getFacing(), Action.EXECUTE);
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.pigmentConsumers.size();
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return;
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.pigmentExtractors == null) {
            PigmentConnectorSettings settings;
            SidedConsumer consumer;
            this.pigmentExtractors = new ArrayList<Pair<SidedConsumer, PigmentConnectorSettings>>();
            this.pigmentConsumers = new ArrayList<Pair<SidedConsumer, PigmentConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (PigmentConnectorSettings)((Object)entry.getValue());
                if (settings.getPigmentMode() == PigmentConnectorSettings.PigmentMode.EXT) {
                    this.pigmentExtractors.add((Pair<SidedConsumer, PigmentConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
                    continue;
                }
                this.pigmentConsumers.add((Pair<SidedConsumer, PigmentConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)settings)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (PigmentConnectorSettings)((Object)entry.getValue());
                if (settings.getPigmentMode() != PigmentConnectorSettings.PigmentMode.INS) continue;
                this.pigmentConsumers.add((Pair<SidedConsumer, PigmentConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
            }
            this.pigmentConsumers.sort((o1, o2) -> ((PigmentConnectorSettings)((Object)((Object)o2.getSecond()))).getPriority().compareTo(((PigmentConnectorSettings)((Object)((Object)o1.getSecond()))).getPriority()));
        }
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 90, 11, 10);
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices("mode", "Pigment distribution mode", (Enum)this.channelMode, (Enum[])ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get("mode")).toUpperCase());
    }

    public static enum ChannelMode {
        PRIORITY,
        DISTRIBUTE;

    }
}

