/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.pigment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.helper.ChannelModule;
import terrails.xnetgases.module.pigment.PigmentChannelSettings;
import terrails.xnetgases.module.pigment.PigmentConnectorSettings;
import terrails.xnetgases.module.pigment.PigmentUtils;

public class PigmentChannelModule
extends ChannelModule {
    public static ForgeConfigSpec.IntValue maxPigmentRateNormal;
    public static ForgeConfigSpec.IntValue maxPigmentRateAdvanced;

    public String getID() {
        return "mekanism.pigment";
    }

    public String getName() {
        return "Mekanism Pigment";
    }

    public boolean supportsBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)world.func_175625_s(pos), direction).isPresent();
    }

    @Nonnull
    public IConnectorSettings createConnector(@Nonnull Direction direction) {
        return new PigmentConnectorSettings(direction);
    }

    @Nonnull
    public IChannelSettings createChannel() {
        return new PigmentChannelSettings();
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        maxPigmentRateNormal = builder.comment("Maximum pigment per operation that a normal connector can input or output").defineInRange("maxPigmentRateNormal", 1000, 1, 1000000000);
        maxPigmentRateAdvanced = builder.comment("Maximum pigment per operation that an advanced connector can input or output").defineInRange("maxPigmentRateAdvanced", 5000, 1, 1000000000);
    }
}

