/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.infuse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.infuse.InfuseChannelSettings;
import terrails.xnetgases.module.infuse.InfuseConnectorSettings;

public class InfuseUtils {
    private static Map<String, InfuseConnectorSettings.InfuseMode> connectorModeCache;
    private static Map<String, InfuseChannelSettings.ChannelMode> channelModeCache;

    @Nonnull
    public static InfuseConnectorSettings.InfuseMode getConnectorModeFrom(String s) {
        if (connectorModeCache == null) {
            connectorModeCache = new HashMap<String, InfuseConnectorSettings.InfuseMode>();
            for (InfuseConnectorSettings.InfuseMode mode : InfuseConnectorSettings.InfuseMode.values()) {
                connectorModeCache.put(mode.name(), mode);
            }
        }
        return connectorModeCache.get(s);
    }

    @Nonnull
    public static InfuseChannelSettings.ChannelMode getChannelModeFrom(String s) {
        if (channelModeCache == null) {
            channelModeCache = new HashMap<String, InfuseChannelSettings.ChannelMode>();
            for (InfuseChannelSettings.ChannelMode mode : InfuseChannelSettings.ChannelMode.values()) {
                channelModeCache.put(mode.name(), mode);
            }
        }
        return channelModeCache.get(s);
    }

    @Nonnull
    public static Optional<IInfusionHandler> getInfuseHandlerFor(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.INFUSION_HANDLER_CAPABILITY != null && provider.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, direction).isPresent()) {
            return Optional.of(provider.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, direction).orElseThrow(() -> new IllegalArgumentException("IInfusionHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof IInfusionHandler.ISidedInfusionHandler && ((IInfusionHandler.ISidedInfusionHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((IInfusionHandler)provider);
        }
        if (!(provider instanceof IInfusionHandler.ISidedInfusionHandler) && provider instanceof IInfusionHandler && ((IInfusionHandler)provider).getTanks() >= 1) {
            return Optional.of((IInfusionHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static InfusionStack insertInfuse(IInfusionHandler handler, InfusionStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            return (InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (InfusionStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static InfusionStack extractInfuse(IInfusionHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            return (InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).extractChemical(amount, direction, action);
        }
        return (InfusionStack)handler.extractChemical(amount, action);
    }

    public static List<InfuseType> getInfuseInTank(@Nonnull IInfusionHandler handler, @Nullable Direction direction) {
        ArrayList<InfuseType> infuses = new ArrayList<InfuseType>();
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            for (int i = 0; i < ((IInfusionHandler.ISidedInfusionHandler)handler).getTanks(direction); ++i) {
                infuses.add((InfuseType)((InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).getChemicalInTank(i, direction)).getType());
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                infuses.add((InfuseType)((InfusionStack)handler.getChemicalInTank(i)).getType());
            }
        }
        return infuses;
    }

    public static List<InfuseType> getInfuseInTank(@Nonnull IInfusionHandler handler) {
        return InfuseUtils.getInfuseInTank(handler, null);
    }

    public static long getInfuseCount(@Nonnull IInfusionHandler handler, @Nullable Direction direction, @Nullable Predicate<InfusionStack> filter) {
        long count = 0L;
        if (handler instanceof IInfusionHandler.ISidedInfusionHandler) {
            for (int i = 0; i < ((IInfusionHandler.ISidedInfusionHandler)handler).getTanks(direction); ++i) {
                InfusionStack stack = (InfusionStack)((IInfusionHandler.ISidedInfusionHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                InfusionStack stack = (InfusionStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long getInfuseCount(@Nonnull IInfusionHandler handler, @Nullable Direction direction, @Nullable InfuseType filter) {
        return InfuseUtils.getInfuseCount(handler, direction, (InfusionStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long getInfuseCount(@Nonnull IInfusionHandler handler, @Nullable Direction direction, @Nullable InfusionStack filter) {
        return InfuseUtils.getInfuseCount(handler, direction, (InfusionStack stack) -> filter == null || stack.equals((Object)filter));
    }

    public static long getInfuseCount(@Nonnull IInfusionHandler handler, @Nullable Direction direction) {
        return InfuseUtils.getInfuseCount(handler, direction, (Predicate<InfusionStack>)null);
    }

    public static long getInfuseCount(@Nonnull IInfusionHandler handler) {
        return InfuseUtils.getInfuseCount(handler, null);
    }
}

