/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.gas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.gas.GasChannelSettings;
import terrails.xnetgases.module.gas.GasConnectorSettings;

public class GasUtils {
    private static Map<String, GasConnectorSettings.GasMode> connectorModeCache;
    private static Map<String, GasChannelSettings.ChannelMode> channelModeCache;

    @Nonnull
    public static GasConnectorSettings.GasMode getConnectorModeFrom(String s) {
        if (connectorModeCache == null) {
            connectorModeCache = new HashMap<String, GasConnectorSettings.GasMode>();
            for (GasConnectorSettings.GasMode mode : GasConnectorSettings.GasMode.values()) {
                connectorModeCache.put(mode.name(), mode);
            }
        }
        return connectorModeCache.get(s);
    }

    @Nonnull
    public static GasChannelSettings.ChannelMode getChannelModeFrom(String s) {
        if (channelModeCache == null) {
            channelModeCache = new HashMap<String, GasChannelSettings.ChannelMode>();
            for (GasChannelSettings.ChannelMode mode : GasChannelSettings.ChannelMode.values()) {
                channelModeCache.put(mode.name(), mode);
            }
        }
        return channelModeCache.get(s);
    }

    @Nonnull
    public static Optional<IGasHandler> getGasHandlerFor(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.GAS_HANDLER_CAPABILITY != null && provider.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, direction).isPresent()) {
            return Optional.of(provider.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, direction).orElseThrow(() -> new IllegalArgumentException("IGasHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof IGasHandler.ISidedGasHandler && ((IGasHandler.ISidedGasHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((IGasHandler)provider);
        }
        if (!(provider instanceof IGasHandler.ISidedGasHandler) && provider instanceof IGasHandler && ((IGasHandler)provider).getTanks() >= 1) {
            return Optional.of((IGasHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static GasStack insertGas(IGasHandler handler, GasStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            return (GasStack)((IGasHandler.ISidedGasHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (GasStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static GasStack extractGas(IGasHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            return (GasStack)((IGasHandler.ISidedGasHandler)handler).extractChemical(amount, direction, action);
        }
        return (GasStack)handler.extractChemical(amount, action);
    }

    public static List<Gas> getGasInTank(@Nonnull IGasHandler handler, @Nullable Direction direction) {
        ArrayList<Gas> gases = new ArrayList<Gas>();
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            for (int i = 0; i < ((IGasHandler.ISidedGasHandler)handler).getTanks(direction); ++i) {
                gases.add((Gas)((GasStack)((IGasHandler.ISidedGasHandler)handler).getChemicalInTank(i, direction)).getType());
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                gases.add((Gas)((GasStack)handler.getChemicalInTank(i)).getType());
            }
        }
        return gases;
    }

    public static List<Gas> getGasInTank(@Nonnull IGasHandler handler) {
        return GasUtils.getGasInTank(handler, null);
    }

    public static long getGasCount(@Nonnull IGasHandler handler, @Nullable Direction direction, @Nullable Predicate<GasStack> filter) {
        long count = 0L;
        if (handler instanceof IGasHandler.ISidedGasHandler) {
            for (int i = 0; i < ((IGasHandler.ISidedGasHandler)handler).getTanks(direction); ++i) {
                GasStack stack = (GasStack)((IGasHandler.ISidedGasHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                GasStack stack = (GasStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long getGasCount(@Nonnull IGasHandler handler, @Nullable Direction direction, @Nullable Gas filter) {
        return GasUtils.getGasCount(handler, direction, (GasStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long getGasCount(@Nonnull IGasHandler handler, @Nullable Direction direction, @Nullable GasStack filter) {
        return GasUtils.getGasCount(handler, direction, (GasStack stack) -> filter == null || stack.equals((Object)filter));
    }

    public static long getGasCount(@Nonnull IGasHandler handler, @Nullable Direction direction) {
        return GasUtils.getGasCount(handler, direction, (Predicate<GasStack>)null);
    }

    public static long getGasCount(@Nonnull IGasHandler handler) {
        return GasUtils.getGasCount(handler, null);
    }
}

