/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.psi.api.cad.ISocketable;

public class SocketWheel
implements ISocketable,
INBTSerializable<CompoundNBT> {
    private final int size;
    private final ItemStackHandler handler;
    private int selectedSlot = 0;

    public SocketWheel() {
        this(12);
    }

    public SocketWheel(int size) {
        this.size = size;
        this.handler = new ItemStackHandler(size);
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.size && slot >= 0;
    }

    @Override
    public List<Integer> getRadialMenuSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            if (!this.isSocketSlotAvailable(i)) continue;
            list.add(i);
        }
        return list;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        this.handler.setStackInSlot(slot, bullet);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.selectedSlot = slot;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack bullet) {
        return this.handler.insertItem(slot, bullet, true).func_190926_b();
    }

    @Override
    public boolean canLoopcast() {
        return false;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = this.handler.serializeNBT();
        compound.func_82580_o("Size");
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        nbt.func_74768_a("Size", this.size);
        this.handler.deserializeNBT(nbt);
    }
}

