/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;

public class WeightedList<U> {
    protected final List<Entry<U>> field_220658_a;
    private final Random field_220659_b = new Random();

    public WeightedList() {
        this(Lists.newArrayList());
    }

    private WeightedList(List<Entry<U>> list) {
        this.field_220658_a = Lists.newArrayList(list);
    }

    public static <U> Codec<WeightedList<U>> func_234002_a_(Codec<U> codec) {
        return Entry.func_234008_a_(codec).listOf().xmap(WeightedList::new, weightedList -> weightedList.field_220658_a);
    }

    public WeightedList<U> func_226313_a_(U u, int n) {
        this.field_220658_a.add(new Entry(u, n));
        return this;
    }

    public WeightedList<U> func_226309_a_() {
        return this.func_226314_a_(this.field_220659_b);
    }

    public WeightedList<U> func_226314_a_(Random random) {
        this.field_220658_a.forEach(entry -> ((Entry)entry).func_220648_a(random.nextFloat()));
        this.field_220658_a.sort(Comparator.comparingDouble(object -> ((Entry)object).func_220649_a()));
        return this;
    }

    public boolean func_234005_b_() {
        return this.field_220658_a.isEmpty();
    }

    public Stream<U> func_220655_b() {
        return this.field_220658_a.stream().map(Entry::func_220647_b);
    }

    public U func_226318_b_(Random random) {
        return this.func_226314_a_(random).func_220655_b().findFirst().orElseThrow(RuntimeException::new);
    }

    public String toString() {
        return "WeightedList[" + this.field_220658_a + "]";
    }

    public static class Entry<T> {
        private final T field_220651_b;
        private final int field_220652_c;
        private double field_220653_d;

        private Entry(T t, int n) {
            this.field_220652_c = n;
            this.field_220651_b = t;
        }

        private double func_220649_a() {
            return this.field_220653_d;
        }

        private void func_220648_a(float f) {
            this.field_220653_d = -Math.pow(f, 1.0f / (float)this.field_220652_c);
        }

        public T func_220647_b() {
            return this.field_220651_b;
        }

        public String toString() {
            return "" + this.field_220652_c + ":" + this.field_220651_b;
        }

        public static <E> Codec<Entry<E>> func_234008_a_(final Codec<E> codec) {
            return new Codec<Entry<E>>(){

                public <T> DataResult<Pair<Entry<E>, T>> decode(DynamicOps<T> dynamicOps, T t) {
                    Dynamic dynamic = new Dynamic(dynamicOps, t);
                    return dynamic.get("data").flatMap(arg_0 -> ((Codec)codec).parse(arg_0)).map(object -> new Entry(object, dynamic.get("weight").asInt(1))).map(entry -> Pair.of((Object)entry, (Object)dynamicOps.empty()));
                }

                public <T> DataResult<T> encode(Entry<E> entry, DynamicOps<T> dynamicOps, T t) {
                    return dynamicOps.mapBuilder().add("weight", dynamicOps.createInt(entry.field_220652_c)).add("data", codec.encodeStart(dynamicOps, entry.field_220651_b)).build(t);
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.encode((Entry)object, dynamicOps, object2);
                }
            };
        }
    }
}

