/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class TextComponentParser {
    public static final Char2ObjectOpenHashMap<TextFormatting> CODE_TO_FORMATTING = new Char2ObjectOpenHashMap();
    private final String text;
    private final Function<String, ITextComponent> substitutes;
    private StringTextComponent component;
    private StringBuilder builder;
    private Style style;

    public static StringTextComponent parse(String text, @Nullable Function<String, ITextComponent> substitutes) {
        return new TextComponentParser(text, substitutes).parse();
    }

    private TextComponentParser(String txt, @Nullable Function<String, ITextComponent> sub) {
        this.text = txt;
        this.substitutes = sub;
    }

    private StringTextComponent parse() {
        if (this.text.isEmpty()) {
            return new StringTextComponent("");
        }
        char[] c = this.text.toCharArray();
        boolean hasSpecialCodes = false;
        for (char c1 : c) {
            if (c1 != '{' && c1 != '&' && c1 != '\u00a7') continue;
            hasSpecialCodes = true;
            break;
        }
        if (!hasSpecialCodes) {
            return new StringTextComponent(this.text);
        }
        this.component = new StringTextComponent("");
        this.style = Style.field_240709_b_;
        this.builder = new StringBuilder();
        boolean sub = false;
        for (int i = 0; i < c.length; ++i) {
            boolean end;
            boolean escape = i > 0 && c[i - 1] == '\\';
            boolean bl = end = i == c.length - 1;
            if (sub && (end || c[i] == '{' || c[i] == '}')) {
                if (c[i] == '{') {
                    throw new IllegalArgumentException("Invalid formatting! Can't nest multiple substitutes!");
                }
                this.finishPart();
                sub = false;
                continue;
            }
            if (!escape) {
                if (c[i] == '\u00a7') {
                    c[i] = 38;
                }
                if (c[i] == '&') {
                    this.finishPart();
                    if (end) {
                        throw new IllegalArgumentException("Invalid formatting! Can't end string with & or \u00a7!");
                    }
                    if (c[++i] == '#') {
                        char[] rrggbb = new char[7];
                        rrggbb[0] = 35;
                        for (int j = 1; j <= 6; ++j) {
                            rrggbb[j] = c[i + j];
                        }
                        i += 6;
                        this.style = this.style.func_240718_a_(Color.func_240745_a_((String)new String(rrggbb)));
                        continue;
                    }
                    TextFormatting formatting = (TextFormatting)CODE_TO_FORMATTING.get(c[i]);
                    if (formatting == null) {
                        throw new IllegalArgumentException("Illegal formatting! Unknown color code character: " + c[i] + "!");
                    }
                    this.style = this.style.func_240721_b_(formatting);
                    continue;
                }
                if (c[i] == '{') {
                    this.finishPart();
                    if (end) {
                        throw new IllegalArgumentException("Invalid formatting! Can't end string with {!");
                    }
                    sub = true;
                }
            }
            if (c[i] == '\\' && !escape) continue;
            this.builder.append(c[i]);
        }
        this.finishPart();
        return this.component;
    }

    private void finishPart() {
        String string = this.builder.toString();
        this.builder.setLength(0);
        if (string.isEmpty()) {
            return;
        }
        if (string.length() < 2 || string.charAt(0) != '{') {
            StringTextComponent component1 = new StringTextComponent(string);
            component1.func_230530_a_(this.style);
            this.component.func_230529_a_((ITextComponent)component1);
            return;
        }
        ITextComponent component1 = this.substitutes.apply(string.substring(1));
        if (component1 == null) {
            throw new IllegalArgumentException("Invalid formatting! Unknown substitute: " + string.substring(1));
        }
        Style style0 = component1.func_150256_b();
        Style style1 = this.style;
        style1.func_240716_a_(style0.func_150210_i());
        style1.func_240715_a_(style0.func_150235_h());
        style1.func_240714_a_(style0.func_179986_j());
        component1 = new StringTextComponent("").func_230529_a_(component1).func_240703_c_(style1);
        this.component.func_230529_a_(component1);
    }

    static {
        CODE_TO_FORMATTING.put('0', (Object)TextFormatting.BLACK);
        CODE_TO_FORMATTING.put('1', (Object)TextFormatting.DARK_BLUE);
        CODE_TO_FORMATTING.put('2', (Object)TextFormatting.DARK_GREEN);
        CODE_TO_FORMATTING.put('3', (Object)TextFormatting.DARK_AQUA);
        CODE_TO_FORMATTING.put('4', (Object)TextFormatting.DARK_RED);
        CODE_TO_FORMATTING.put('5', (Object)TextFormatting.DARK_PURPLE);
        CODE_TO_FORMATTING.put('6', (Object)TextFormatting.GOLD);
        CODE_TO_FORMATTING.put('7', (Object)TextFormatting.GRAY);
        CODE_TO_FORMATTING.put('8', (Object)TextFormatting.DARK_GRAY);
        CODE_TO_FORMATTING.put('9', (Object)TextFormatting.BLUE);
        CODE_TO_FORMATTING.put('a', (Object)TextFormatting.GREEN);
        CODE_TO_FORMATTING.put('b', (Object)TextFormatting.AQUA);
        CODE_TO_FORMATTING.put('c', (Object)TextFormatting.RED);
        CODE_TO_FORMATTING.put('d', (Object)TextFormatting.LIGHT_PURPLE);
        CODE_TO_FORMATTING.put('e', (Object)TextFormatting.YELLOW);
        CODE_TO_FORMATTING.put('f', (Object)TextFormatting.WHITE);
        CODE_TO_FORMATTING.put('k', (Object)TextFormatting.OBFUSCATED);
        CODE_TO_FORMATTING.put('l', (Object)TextFormatting.BOLD);
        CODE_TO_FORMATTING.put('m', (Object)TextFormatting.STRIKETHROUGH);
        CODE_TO_FORMATTING.put('n', (Object)TextFormatting.UNDERLINE);
        CODE_TO_FORMATTING.put('o', (Object)TextFormatting.ITALIC);
        CODE_TO_FORMATTING.put('r', (Object)TextFormatting.RESET);
    }
}

