/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.impl.FTBRanksAPIImpl;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class FTBRanksCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbranks").requires(source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2))).then(Commands.func_197057_a((String)"reload").executes(context -> FTBRanksCommands.reloadRanks((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"refresh_readme").executes(context -> FTBRanksCommands.refreshReadme((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"list_all_ranks").executes(context -> FTBRanksCommands.listAllRanks((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.createRank((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.func_197057_a((String)"delete").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.deleteRank((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.addRank((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.removeRank((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.func_197057_a((String)"list_ranks_of").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FTBRanksCommands.listRanksOf((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))))).then(Commands.func_197057_a((String)"list_players_with").then(Commands.func_197056_a((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.listPlayersWith((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))));
    }

    private static String normalizeRankName(String name) {
        return name.toLowerCase().replace("+", "_plus").replaceAll("[^a-z0-9_]", "_").replaceAll("_{2,}", "_");
    }

    private static int reloadRanks(CommandSource source) {
        try {
            FTBRanksAPIImpl.manager.reload();
            source.func_197030_a((ITextComponent)new StringTextComponent("Ranks reloaded!"), true);
            for (ServerPlayerEntity p : source.func_197028_i().func_184103_al().func_181057_v()) {
                source.func_197028_i().func_184103_al().func_187243_f(p);
            }
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            source.func_197021_a((ITextComponent)new StringTextComponent(ex.getLocalizedMessage()));
            return 0;
        }
    }

    private static int refreshReadme(CommandSource source) {
        try {
            FTBRanksAPIImpl.manager.refreshReadme();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Done!"), false);
        return 1;
    }

    private static int listAllRanks(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Ranks:"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("- " + rank.getName()).func_240699_a_(rank.getCondition().isDefaultCondition() ? TextFormatting.AQUA : TextFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int createRank(CommandSource source, String name) throws CommandSyntaxException {
        String id = FTBRanksCommands.normalizeRankName(name);
        if (FTBRanksAPIImpl.manager.getRank(id).isPresent()) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Rank ID already taken!"));
            return 0;
        }
        FTBRanksAPIImpl.manager.createRank(id, name);
        source.func_197030_a((ITextComponent)new StringTextComponent("Rank created with id '" + id + "'!"), false);
        return 1;
    }

    private static int deleteRank(CommandSource source, String name) throws CommandSyntaxException {
        if (FTBRanksAPIImpl.manager.deleteRank(FTBRanksCommands.normalizeRankName(name)) == null) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Rank not found!"));
            return 0;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Rank deleted!"), false);
        return 1;
    }

    private static int addRank(CommandSource source, Collection<GameProfile> players, String name) throws CommandSyntaxException {
        Rank r = FTBRanksAPIImpl.manager.getRank(FTBRanksCommands.normalizeRankName(name)).orElseThrow(NullPointerException::new);
        for (GameProfile profile : players) {
            if (!r.add(profile)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("Added '" + r.getName() + "' to " + profile.getName()), false);
        }
        return 1;
    }

    private static int removeRank(CommandSource source, Collection<GameProfile> players, String name) throws CommandSyntaxException {
        Rank r = FTBRanksAPIImpl.manager.getRank(FTBRanksCommands.normalizeRankName(name)).orElseThrow(NullPointerException::new);
        for (GameProfile profile : players) {
            if (!r.remove(profile)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("Removed '" + r.getName() + "' from " + profile.getName()), false);
        }
        return 1;
    }

    private static int listRanksOf(CommandSource source, ServerPlayerEntity player) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Ranks added to " + player.func_146103_bH().getName() + ":"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            if (!rank.isActive(player)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("- " + rank.getName()).func_240699_a_(rank.getCondition().isDefaultCondition() ? TextFormatting.AQUA : TextFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int listPlayersWith(CommandSource source, String name) {
        Rank r = FTBRanksAPIImpl.manager.getRank(FTBRanksCommands.normalizeRankName(name)).orElseThrow(NullPointerException::new);
        source.func_197030_a((ITextComponent)new StringTextComponent("Players with " + name + " added to them:"), false);
        for (ServerPlayerEntity player : source.func_197028_i().func_184103_al().func_181057_v()) {
            if (!r.isActive(player)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("- ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_(player.func_145748_c_()), false);
        }
        return 1;
    }
}

