/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.util.IResourceStorage;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.ItemHelper;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandler;

public class ItemStorageCoFH
implements IItemHandler,
IItemStackAccess,
IResourceStorage {
    protected final int baseCapacity;
    protected BooleanSupplier creative = Constants.FALSE;
    protected BooleanSupplier enabled = Constants.TRUE;
    protected Supplier<ItemStack> emptyItem = Constants.EMPTY_ITEM;
    protected Predicate<ItemStack> validator;
    @Nonnull
    protected ItemStack item = ItemStack.field_190927_a;
    protected int capacity;

    public ItemStorageCoFH() {
        this(e -> true);
    }

    public ItemStorageCoFH(int capacity) {
        this(capacity, e -> true);
    }

    public ItemStorageCoFH(Predicate<ItemStack> validator) {
        this(0, validator);
    }

    public ItemStorageCoFH(int capacity, Predicate<ItemStack> validator) {
        this.baseCapacity = capacity;
        this.capacity = capacity;
        this.validator = validator;
    }

    public ItemStorageCoFH applyModifiers(float storageMod) {
        if (this.baseCapacity > 0) {
            this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        }
        return this;
    }

    public ItemStorageCoFH setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public ItemStorageCoFH setEmptyItem(Supplier<ItemStack> emptyItemSupplier) {
        if (emptyItemSupplier != null && emptyItemSupplier.get() != null) {
            this.emptyItem = emptyItemSupplier;
        }
        if (this.item.func_190926_b()) {
            this.setItemStack(this.emptyItem.get());
        }
        return this;
    }

    public ItemStorageCoFH setCreative(BooleanSupplier creative) {
        this.creative = creative;
        if (!this.item.func_190926_b() && this.isCreative()) {
            this.item.func_190920_e(this.getCapacity());
        }
        return this;
    }

    public ItemStorageCoFH setEnabled(BooleanSupplier enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
        return this;
    }

    public ItemStorageCoFH setValidator(Predicate<ItemStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isItemValid(@Nonnull ItemStack stack) {
        return this.enabled.getAsBoolean() && this.validator.test(stack);
    }

    public void consume(int amount) {
        this.item = ItemHelper.consumeItem(this.item, amount);
    }

    public void setItemStack(ItemStack item) {
        this.item = item.func_190926_b() ? this.emptyItem.get() : item;
    }

    public ItemStorageCoFH read(CompoundNBT nbt) {
        this.item = ItemStack.func_199557_a((CompoundNBT)nbt);
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        this.item.func_77955_b(nbt);
        return nbt;
    }

    @Override
    public ItemStack getItemStack() {
        return this.item;
    }

    @Override
    public int getCount() {
        return this.item.func_190916_E();
    }

    @Override
    public boolean isEmpty() {
        return this.item.func_190926_b();
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.item;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(stack) || !this.enabled.getAsBoolean()) {
            return stack;
        }
        if (this.item.func_190926_b()) {
            if (!simulate) {
                this.setItemStack(stack);
            }
            return ItemStack.field_190927_a;
        }
        if (ItemHelper.itemsEqualWithTags(this.item, stack)) {
            int limit;
            int totalCount = this.item.func_190916_E() + stack.func_190916_E();
            if (totalCount <= (limit = this.getSlotLimit(0))) {
                if (!simulate) {
                    this.item.func_190920_e(totalCount);
                }
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                this.item.func_190920_e(limit);
            }
            return ItemHelper.cloneStack(stack, totalCount - limit);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || this.item.func_190926_b() || !this.enabled.getAsBoolean()) {
            return ItemStack.field_190927_a;
        }
        int retCount = Math.min(this.item.func_190916_E(), amount);
        ItemStack ret = ItemHelper.cloneStack(this.item, retCount);
        if (!simulate && !this.isCreative()) {
            this.item.func_190918_g(retCount);
            if (this.item.func_190926_b()) {
                this.setItemStack(this.emptyItem.get());
            }
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.capacity <= 0 ? this.item.func_77976_d() : this.capacity;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.isItemValid(stack);
    }

    @Override
    public boolean clear() {
        if (this.isEmpty()) {
            return false;
        }
        this.item = this.emptyItem.get();
        return true;
    }

    @Override
    public void modify(int quantity) {
        if (this.isCreative()) {
            quantity = Math.max(quantity, 0);
        }
        this.item.func_190920_e(Math.min(this.item.func_190916_E() + quantity, this.getCapacity()));
        if (this.item.func_190926_b()) {
            this.item = this.emptyItem.get();
        }
    }

    @Override
    public boolean isCreative() {
        return this.creative.getAsBoolean();
    }

    @Override
    public int getCapacity() {
        return this.getSlotLimit(0);
    }

    @Override
    public int getStored() {
        return this.item.func_190916_E();
    }

    @Override
    public String getUnit() {
        return "";
    }
}

