/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.network.packet.server.SideConfigPacket;
import cofh.core.util.control.IReconfigurableTile;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.BlockHelper;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;

public class ReconfigControlModule
implements IReconfigurable {
    protected IReconfigurableTile tile;
    protected BooleanSupplier enabled;
    protected Direction facing = Direction.NORTH;
    protected IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};

    public ReconfigControlModule(IReconfigurableTile tile) {
        this(tile, Constants.TRUE);
    }

    public ReconfigControlModule(IReconfigurableTile tile, BooleanSupplier enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public ReconfigControlModule setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public IReconfigurable.SideConfig[] getSideConfig() {
        return this.sides;
    }

    public byte[] getRawSideConfig() {
        byte[] raw = new byte[6];
        for (int i = 0; i < 6; ++i) {
            raw[i] = (byte)this.sides[i].ordinal();
        }
        return raw;
    }

    public void initSideConfig(Direction side, IReconfigurable.SideConfig config) {
        if (side == null || config == null) {
            return;
        }
        this.sides[side.ordinal()] = config;
    }

    public void initSideConfig(IReconfigurable.SideConfig[] sides) {
        if (sides == null || sides.length != 6) {
            return;
        }
        this.sides = sides;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public void setSideConfig(IReconfigurable.SideConfig[] sides) {
        this.sides = sides;
        this.tile.onControlUpdate();
    }

    public void readFromBuffer(PacketBuffer buffer) {
        this.facing = Direction.func_82600_a((int)buffer.readByte());
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = IReconfigurable.SideConfig.VALUES[buffer.readByte()];
        }
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.facing.func_176745_a());
        for (int i = 0; i < 6; ++i) {
            buffer.writeByte(this.sides[i].ordinal());
        }
    }

    public ReconfigControlModule read(CompoundNBT nbt) {
        byte[] bSides = nbt.func_74770_j("Sides");
        if (bSides.length == 6) {
            this.sides[BlockHelper.below((Direction)this.facing).func_176745_a()] = IReconfigurable.SideConfig.VALUES[bSides[0]];
            this.sides[BlockHelper.above((Direction)this.facing).func_176745_a()] = IReconfigurable.SideConfig.VALUES[bSides[1]];
            this.sides[this.facing.func_176745_a()] = IReconfigurable.SideConfig.VALUES[bSides[2]];
            this.sides[BlockHelper.opposite((Direction)this.facing).func_176745_a()] = IReconfigurable.SideConfig.VALUES[bSides[3]];
            this.sides[BlockHelper.right((Direction)this.facing).func_176745_a()] = IReconfigurable.SideConfig.VALUES[bSides[4]];
            this.sides[BlockHelper.left((Direction)this.facing).func_176745_a()] = IReconfigurable.SideConfig.VALUES[bSides[5]];
        }
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.isReconfigurable()) {
            byte[] bSides = new byte[]{(byte)this.sides[BlockHelper.below(this.facing).func_176745_a()].ordinal(), (byte)this.sides[BlockHelper.above(this.facing).func_176745_a()].ordinal(), (byte)this.sides[this.facing.func_176745_a()].ordinal(), (byte)this.sides[BlockHelper.opposite(this.facing).func_176745_a()].ordinal(), (byte)this.sides[BlockHelper.right(this.facing).func_176745_a()].ordinal(), (byte)this.sides[BlockHelper.left(this.facing).func_176745_a()].ordinal()};
            nbt.func_74773_a("Sides", bSides);
        }
        return nbt;
    }

    public ReconfigControlModule readSettings(CompoundNBT nbt) {
        if (this.isReconfigurable()) {
            return this.read(nbt);
        }
        return this;
    }

    public CompoundNBT writeSettings(CompoundNBT nbt) {
        return this.write(nbt);
    }

    public void disable() {
        this.sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_ACCESSIBLE, IReconfigurable.SideConfig.SIDE_ACCESSIBLE, IReconfigurable.SideConfig.SIDE_ACCESSIBLE, IReconfigurable.SideConfig.SIDE_ACCESSIBLE, IReconfigurable.SideConfig.SIDE_ACCESSIBLE, IReconfigurable.SideConfig.SIDE_ACCESSIBLE};
        this.sides[this.facing.ordinal()] = IReconfigurable.SideConfig.SIDE_NONE;
        this.tile.onControlUpdate();
    }

    public IReconfigurable.SideConfig getSideConfig(int side) {
        if (side > 5) {
            return IReconfigurable.SideConfig.SIDE_ACCESSIBLE;
        }
        return this.sides[side];
    }

    @Override
    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public boolean isReconfigurable() {
        return this.enabled.getAsBoolean();
    }

    @Override
    public IReconfigurable.SideConfig getSideConfig(Direction side) {
        if (side == null || !this.isReconfigurable()) {
            return IReconfigurable.SideConfig.SIDE_ACCESSIBLE;
        }
        return this.sides[side.ordinal()];
    }

    @Override
    public boolean prevSideConfig(Direction side) {
        if (!this.isReconfigurable() || side == null) {
            return false;
        }
        this.sides[side.ordinal()] = this.sides[side.ordinal()].prev();
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean nextSideConfig(Direction side) {
        if (!this.isReconfigurable() || side == null) {
            return false;
        }
        this.sides[side.ordinal()] = this.sides[side.ordinal()].next();
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean setSideConfig(Direction side, IReconfigurable.SideConfig config) {
        if (!this.isReconfigurable() || side == null || config == null) {
            return false;
        }
        this.sides[side.ordinal()] = config;
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean clearAllSides() {
        this.sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};
        if (Utils.isClientWorld(this.tile.world())) {
            SideConfigPacket.sendToServer(this.tile);
        } else {
            this.tile.onControlUpdate();
        }
        return true;
    }

    @Override
    public boolean hasInputSide() {
        if (!this.isReconfigurable()) {
            return false;
        }
        for (IReconfigurable.SideConfig side : this.sides) {
            if (!side.isInput()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOutputSide() {
        if (!this.isReconfigurable()) {
            return false;
        }
        for (IReconfigurable.SideConfig side : this.sides) {
            if (!side.isOutput()) continue;
            return true;
        }
        return false;
    }
}

