/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.tileentity.TileCoFH;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.IInventoryCallback;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StorageClearPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected int storageType;
    protected int storageIndex;

    public StorageClearPacket() {
        super(37, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof IInventoryCallback) {
            switch (StorageType.values()[this.storageType]) {
                case ENERGY: {
                    ((IInventoryCallback)tile).clearEnergy(this.storageIndex);
                    break;
                }
                case FLUID: {
                    ((IInventoryCallback)tile).clearTank(this.storageIndex);
                    break;
                }
                case ITEM: {
                    ((IInventoryCallback)tile).clearSlot(this.storageIndex);
                }
            }
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.storageType);
        buf.writeInt(this.storageIndex);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.storageType = buf.readInt();
        this.storageIndex = buf.readInt();
    }

    public static boolean sendToServer(TileCoFH tile, StorageType storageType, int storageIndex) {
        if (tile == null) {
            return false;
        }
        StorageClearPacket packet = new StorageClearPacket();
        packet.pos = tile.pos();
        packet.storageType = storageType.ordinal();
        packet.storageIndex = storageIndex;
        packet.sendToServer();
        return true;
    }

    public static enum StorageType {
        ENERGY,
        FLUID,
        ITEM;

        public static final StorageType[] VALUES;

        static {
            VALUES = StorageType.values();
        }
    }
}

