/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.darkhax.bookshelf.util.ModUtils;
import net.darkhax.enchdesc.Configuration;
import net.darkhax.enchdesc.EnchantmentDescriptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentDescriptionsClient {
    private final KeyBinding keybind = new KeyBinding("key.enchdesc.show", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.KEYSYM, 340, "key.enchdesc.title");
    private final Configuration config = new Configuration();
    private static final Map<Enchantment, IFormattableTextComponent> descriptions = new HashMap<Enchantment, IFormattableTextComponent>();

    public EnchantmentDescriptionsClient() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, this.config.getSpec());
        MinecraftForge.EVENT_BUS.addListener(this::onTooltipDisplayed);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keybind);
    }

    public static final IFormattableTextComponent getDescription(Enchantment ench) {
        return descriptions.computeIfAbsent(ench, e -> {
            IFormattableTextComponent description = new TranslationTextComponent(e.func_77320_a() + ".desc").func_240699_a_(TextFormatting.DARK_GRAY);
            if (!I18n.func_188566_a((String)(e.func_77320_a() + ".desc")) && I18n.func_188566_a((String)(e.func_77320_a() + ".description"))) {
                description = new TranslationTextComponent(e.func_77320_a() + ".description").func_240699_a_(TextFormatting.DARK_GRAY);
            }
            return description;
        });
    }

    private void onTooltipDisplayed(ItemTooltipEvent event) {
        try {
            ItemStack stack = event.getItemStack();
            if (!(stack.func_190926_b() || EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty() || this.config.onlyShowOnEnchantedBooks() && !(stack.func_77973_b() instanceof EnchantedBookItem))) {
                if (!this.config.requiresKeybindPress() || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)this.keybind.getKey().func_197937_c())) {
                    this.insertDescriptionTooltips(event.getToolTip(), stack);
                } else if (this.config.requiresKeybindPress()) {
                    event.getToolTip().add(new StringTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.enchdesc.activate", (Object[])new Object[]{TextFormatting.LIGHT_PURPLE, I18n.func_135052_a((String)this.keybind.func_197982_m(), (Object[])new Object[0]), TextFormatting.GRAY})));
                }
            }
        }
        catch (Exception e) {
            event.getToolTip().add(new TranslationTextComponent("enchdesc.fatalerror").func_240699_a_(TextFormatting.RED));
            EnchantmentDescriptions.LOG.error("Ran into issues displaying tooltip for {}", (Object)event.getItemStack());
            EnchantmentDescriptions.LOG.catching((Throwable)e);
        }
    }

    private void insertDescriptionTooltips(List<ITextComponent> tips, ItemStack stack) {
        Iterator enchants = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet().iterator();
        block0: while (enchants.hasNext()) {
            Enchantment enchant = (Enchantment)enchants.next();
            ListIterator<ITextComponent> tooltips = tips.listIterator();
            while (tooltips.hasNext()) {
                ITextComponent component = tooltips.next();
                if (!(component instanceof TranslationTextComponent) || !((TranslationTextComponent)component).func_150268_i().equals(enchant.func_77320_a())) continue;
                tooltips.add((ITextComponent)EnchantmentDescriptionsClient.getDescription(enchant));
                ModContainer mod = ModUtils.getOwner((IForgeRegistryEntry)enchant);
                if (this.config.shouldShowOwner() && mod != null) {
                    ITextComponent modName = ModUtils.getModName((ModContainer)mod);
                    if (modName instanceof IFormattableTextComponent) {
                        ((IFormattableTextComponent)modName).func_240699_a_(TextFormatting.BLUE);
                    }
                    tooltips.add((ITextComponent)new TranslationTextComponent("tooltip.enchdesc.addedby", new Object[]{modName}).func_240699_a_(TextFormatting.DARK_GRAY));
                }
                if (!this.config.shouldAddNewlines() || !enchants.hasNext()) continue block0;
                tooltips.add((ITextComponent)new StringTextComponent(""));
                continue block0;
            }
        }
    }
}

