/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MiscUtil {
    private static final int WRAP_LENGTH = 45;

    public static void appendMultilineText(List<ITextComponent> result, TextFormatting formatting, String key, Object ... args) {
        for (String s : I18n.func_135052_a((String)key, (Object[])args).split(Pattern.quote("${br}"))) {
            result.add((ITextComponent)new StringTextComponent(s).func_240699_a_(formatting));
        }
    }

    public static IFormattableTextComponent asFormattable(ITextComponent component) {
        return component instanceof IFormattableTextComponent ? (IFormattableTextComponent)component : component.func_230531_f_();
    }

    public static List<String> wrapString(String text) {
        return MiscUtil.wrapString(text, 45);
    }

    public static List<ITextComponent> wrapStringAsTextComponent(String text) {
        return MiscUtil.wrapString(text, 45).stream().map(StringTextComponent::new).collect(Collectors.toList());
    }

    public static String commify(int n) {
        return NumberFormat.getNumberInstance().format(n);
    }

    public static List<String> wrapString(String text, int maxCharPerLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(text.length());
        String format = "";
        for (String para : text.split(Pattern.quote("${br}"))) {
            StringTokenizer tok = new StringTokenizer(para, " ");
            int lineLen = 0;
            while (tok.hasMoreTokens()) {
                String word = tok.nextToken();
                int idx = word.lastIndexOf("\u00a7");
                if (idx >= 0 && idx < word.length() - 1) {
                    format = word.substring(idx, idx + 2);
                    lineLen -= 2;
                }
                if (lineLen + word.length() > maxCharPerLine) {
                    result.add(builder.toString());
                    builder.delete(0, builder.length());
                    builder.append(format);
                    lineLen = 0;
                } else if (lineLen > 0) {
                    builder.append(" ");
                    ++lineLen;
                }
                builder.append(word);
                lineLen += word.length();
            }
            result.add(builder.toString());
            builder.delete(0, builder.length());
            builder.append(format);
        }
        return result;
    }

    public static String locToString(ResourceLocation dim, BlockPos pos) {
        String s = dim.func_110624_b().equals("minecraft") ? dim.func_110623_a() : dim.toString();
        return String.format("%s [%d,%d,%d]", s, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static String locToString(GlobalPos pos) {
        return MiscUtil.locToString(pos.func_239646_a_().func_240901_a_(), pos.func_218180_b());
    }

    public static ResourceLocation RL(String name) {
        return new ResourceLocation("modularrouters", name);
    }

    public static int getYawFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static ITextComponent settingsStr(String prefix, ITextComponent c) {
        return new StringTextComponent(prefix).func_230529_a_(c);
    }

    public static CompoundNBT serializeGlobalPos(GlobalPos globalPos) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)globalPos.func_218180_b()));
        tag.func_74778_a("dim", globalPos.func_239646_a_().func_240901_a_().toString());
        return tag;
    }

    public static GlobalPos deserializeGlobalPos(CompoundNBT tag) {
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("dim")));
        return GlobalPos.func_239648_a_((RegistryKey)worldKey, (BlockPos)NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("pos")));
    }

    public static ServerWorld getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(pos.func_239646_a_());
    }

    public static GlobalPos makeGlobalPos(World w, BlockPos pos) {
        return GlobalPos.func_239648_a_((RegistryKey)w.func_234923_W_(), (BlockPos)pos);
    }

    public static boolean blockHasSolidSide(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return Block.func_208061_a((VoxelShape)state.func_196951_e(worldIn, pos), (Direction)side);
    }
}

