/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExclusionRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ICraftingRecipe parent;
    private final List<ResourceLocation> excluded;

    public ExclusionRecipe(ICraftingRecipe parent, List<ResourceLocation> excluded) {
        this.parent = parent;
        this.excluded = excluded;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        for (ResourceLocation recipeLoc : this.excluded) {
            IRecipe recipe;
            Optional recipeHolder = worldIn.func_199532_z().func_215367_a(recipeLoc);
            if (!recipeHolder.isPresent() || !((recipe = (IRecipe)recipeHolder.get()) instanceof ICraftingRecipe) || !((ICraftingRecipe)recipe).func_77569_a((IInventory)inv, worldIn)) continue;
            return false;
        }
        return this.parent.func_77569_a((IInventory)inv, worldIn);
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        return this.parent.func_77572_b((IInventory)inv);
    }

    public boolean func_194133_a(int width, int height) {
        return this.parent.func_194133_a(width, height);
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.parent.func_77571_b();
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.parent.func_199560_c();
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return this.parent.func_222127_g();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return this.parent.func_179532_b((IInventory)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.parent.func_192400_c();
    }

    public boolean func_192399_d() {
        return this.parent.func_192399_d();
    }

    @Nonnull
    public String func_193358_e() {
        return this.parent.func_193358_e();
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return this.parent.func_222128_h();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ExclusionRecipe> {
        public Serializer() {
            this.setRegistryName("quark:exclusion");
        }

        @Nonnull
        public ExclusionRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String trueType = JSONUtils.func_151200_h((JsonObject)json, (String)"true_type");
            if (trueType.equals("quark:exclusion")) {
                throw new JsonSyntaxException("Recipe type circularity");
            }
            JsonArray excluded = JSONUtils.func_151214_t((JsonObject)json, (String)"exclusions");
            ArrayList<ResourceLocation> excludedRecipes = new ArrayList<ResourceLocation>();
            for (JsonElement el : excluded) {
                ResourceLocation loc = new ResourceLocation(el.getAsString());
                if (loc.equals((Object)recipeId)) continue;
                excludedRecipes.add(loc);
            }
            Optional serializer = Registry.field_218368_I.func_241873_b(new ResourceLocation(trueType));
            if (!serializer.isPresent()) {
                throw new JsonSyntaxException("Invalid or unsupported recipe type '" + trueType + "'");
            }
            IRecipe parent = ((IRecipeSerializer)serializer.get()).func_199425_a_(recipeId, json);
            if (!(parent instanceof ICraftingRecipe)) {
                throw new JsonSyntaxException("Type '" + trueType + "' is not a crafting recipe");
            }
            if (parent instanceof IShapedRecipe) {
                return new ShapedExclusionRecipe((ICraftingRecipe)parent, excludedRecipes);
            }
            return new ExclusionRecipe((ICraftingRecipe)parent, excludedRecipes);
        }

        @Nonnull
        public ExclusionRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            int exclusions = buffer.func_150792_a();
            ArrayList<ResourceLocation> excludedRecipes = new ArrayList<ResourceLocation>();
            for (int i = 0; i < exclusions; ++i) {
                ResourceLocation loc = new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE));
                if (loc.equals((Object)recipeId)) continue;
                excludedRecipes.add(loc);
            }
            String trueType = buffer.func_150789_c(Short.MAX_VALUE);
            IRecipeSerializer serializer = (IRecipeSerializer)Registry.field_218368_I.func_241873_b(new ResourceLocation(trueType)).orElseThrow(() -> new IllegalArgumentException("Invalid or unsupported recipe type '" + trueType + "'"));
            IRecipe parent = serializer.func_199426_a_(recipeId, buffer);
            if (!(parent instanceof ICraftingRecipe)) {
                throw new IllegalArgumentException("Type '" + trueType + "' is not a crafting recipe");
            }
            if (parent instanceof IShapedRecipe) {
                return new ShapedExclusionRecipe((ICraftingRecipe)parent, excludedRecipes);
            }
            return new ExclusionRecipe((ICraftingRecipe)parent, excludedRecipes);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull ExclusionRecipe recipe) {
            buffer.func_150787_b(recipe.excluded.size());
            for (ResourceLocation loc : recipe.excluded) {
                buffer.func_211400_a(loc.toString(), Short.MAX_VALUE);
            }
            buffer.func_211400_a(Objects.toString(recipe.parent.func_199559_b().getRegistryName()), Short.MAX_VALUE);
            recipe.parent.func_199559_b().func_199427_a_(buffer, (IRecipe)recipe.parent);
        }
    }

    private static class ShapedExclusionRecipe
    extends ExclusionRecipe
    implements IShapedRecipe<CraftingInventory> {
        private final IShapedRecipe<CraftingInventory> parent;

        public ShapedExclusionRecipe(ICraftingRecipe parent, List<ResourceLocation> excluded) {
            super(parent, excluded);
            this.parent = (IShapedRecipe)parent;
        }

        public int getRecipeWidth() {
            return this.parent.getRecipeWidth();
        }

        public int getRecipeHeight() {
            return this.parent.getRecipeHeight();
        }
    }
}

