/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;
import vazkii.quark.base.client.config.gui.AbstractQScreen;
import vazkii.quark.base.client.config.gui.widget.ScrollableWidgetList;

public abstract class AbstractScrollingWidgetScreen
extends AbstractQScreen {
    private List<Widget> scrollingWidgets = new LinkedList<Widget>();
    private ScrollableWidgetList<?, ?> elementList;
    private Button resetButton;
    private boolean needsScrollUpdate = false;
    private double currentScroll = 0.0;

    public AbstractScrollingWidgetScreen(Screen parent) {
        super(parent);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.elementList = this.createWidgetList();
        this.field_230705_e_.add(this.elementList);
        this.refresh();
        this.needsScrollUpdate = true;
        int pad = 3;
        int bWidth = 121;
        int left = (this.field_230708_k_ - (bWidth + pad) * 3) / 2;
        int vStart = this.field_230709_l_ - 30;
        this.func_230480_a_((Widget)new Button(left, vStart, bWidth, 20, (ITextComponent)new TranslationTextComponent("quark.gui.config.default"), this::onClickDefault));
        this.resetButton = new Button(left + bWidth + pad, vStart, bWidth, 20, (ITextComponent)new TranslationTextComponent("quark.gui.config.discard"), this::onClickDiscard);
        this.func_230480_a_((Widget)this.resetButton);
        this.func_230480_a_((Widget)new Button(left + (bWidth + pad) * 2, vStart, bWidth, 20, (ITextComponent)new TranslationTextComponent("gui.done"), this::onClickDone));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.resetButton.field_230693_o_ = this.isDirty();
    }

    public void refresh() {
        this.field_230705_e_.removeIf(this.scrollingWidgets::contains);
        this.field_230710_m_.removeIf(this.scrollingWidgets::contains);
        this.scrollingWidgets.clear();
        this.elementList.populate(w -> {
            this.field_230705_e_.add(w);
            this.scrollingWidgets.add((Widget)w);
            if (w instanceof Button) {
                this.func_230480_a_((Widget)w);
            }
        });
    }

    @Override
    public void func_230430_a_(MatrixStack mstack, int mouseX, int mouseY, float pticks) {
        if (this.needsScrollUpdate) {
            this.elementList.func_230932_a_(this.currentScroll);
            this.needsScrollUpdate = false;
        }
        this.currentScroll = this.elementList.func_230966_l_();
        this.scrollingWidgets.forEach(w -> {
            w.field_230694_p_ = false;
        });
        this.func_230446_a_(mstack);
        this.elementList.func_230430_a_(mstack, mouseX, mouseY, pticks);
        LinkedList visibleWidgets = new LinkedList();
        this.scrollingWidgets.forEach(w -> {
            if (w.field_230694_p_) {
                visibleWidgets.add(w);
            }
            w.field_230694_p_ = false;
        });
        super.func_230430_a_(mstack, mouseX, mouseY, pticks);
        MainWindow main = this.field_230706_i_.func_228018_at_();
        int res = (int)main.func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)(40 * res), (int)(this.field_230708_k_ * res), (int)((this.field_230709_l_ - 80) * res));
        visibleWidgets.forEach(w -> {
            w.field_230694_p_ = true;
            w.func_230430_a_(mstack, mouseX, mouseY, pticks);
        });
        GL11.glDisable((int)3089);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        return super.func_231044_a_(x, y, button);
    }

    protected abstract ScrollableWidgetList<?, ?> createWidgetList();

    protected abstract void onClickDefault(Button var1);

    protected abstract void onClickDiscard(Button var1);

    protected abstract boolean isDirty();

    protected void onClickDone(Button b) {
        this.returnToParent(b);
    }
}

