/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.FTBAuxiliumConfig;
import dev.ftb.mods.ftbauxilium.auxilium.AnonymousIdentification;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.SessionCollector;
import dev.ftb.mods.ftbauxilium.tasks.LaunchTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelExitTask;
import dev.ftb.mods.ftbauxilium.tasks.LevelLoadTask;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import org.jetbrains.annotations.Nullable;

public class StatManager {
    private static final AnonymousIdentification IDENTIFIER = new AnonymousIdentification();
    private final long instanceStartTime = System.currentTimeMillis();
    private float loadTimeInSeconds = 0.0f;
    private ModpackData packData;
    private String sessionToken = "";
    private SessionCollector session;
    private Launchers launcher = Launchers.UNKNOWN;

    public static AnonymousIdentification identifier() {
        return IDENTIFIER;
    }

    public void init() {
        FTBAuxilium.LOGGER.debug("Starting stat system");
        this.packData = new ModpackData();
        ClientLifecycleEvent.CLIENT_SETUP.register(this::clientLoaded);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::worldLoaded);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::onLevelExit);
    }

    private void worldLoaded(@Nullable ClientPlayerEntity localPlayer) {
        if (StatManager.identifier().isOptedOut() || !FTBAuxiliumConfig.get().isEnabled) {
            return;
        }
        Minecraft.func_71410_x().execute(() -> FTBAuxilium.runTask(new LevelLoadTask()));
    }

    public void onLevelExit(@Nullable ClientPlayerEntity localPlayer) {
        if (localPlayer == null || StatManager.identifier().isOptedOut() || !FTBAuxiliumConfig.get().isEnabled) {
            return;
        }
        Minecraft.func_71410_x().execute(() -> FTBAuxilium.runTask(new LevelExitTask()));
    }

    public void clientLoaded(Minecraft minecraft) {
        if (StatManager.identifier().isOptedOut() || !FTBAuxiliumConfig.get().isEnabled) {
            return;
        }
        this.loadTimeInSeconds = (float)(System.currentTimeMillis() - this.instanceStartTime) / 1000.0f;
        this.launcher = this.findLauncher();
        FTBAuxilium.LOGGER.debug("Launcher found: {}", (Object)this.launcher.getName());
        minecraft.execute(() -> FTBAuxilium.runTask(new LaunchTask(minecraft, this.launcher)));
    }

    private Launchers findLauncher() {
        File gameDirectory = Minecraft.func_71410_x().field_71412_D.getAbsoluteFile();
        for (Launchers value : Launchers.values()) {
            if (value == Launchers.UNKNOWN || !value.exists(gameDirectory)) continue;
            return value;
        }
        return Launchers.UNKNOWN;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public ModpackData getPackData() {
        return this.packData;
    }

    public float getLoadTimeInSeconds() {
        return this.loadTimeInSeconds;
    }

    public SessionCollector getSession() {
        return this.session;
    }

    public void setSession(SessionCollector session) {
        this.session = session;
    }

    public static enum Launchers {
        FTB("FTB App", "/modpack.json"),
        MULTI("MultiMc", "/../mmc-pack.json"),
        CURSE("Curse", "/.curseclient"),
        GD("GDLauncher", "/config.json"),
        UNKNOWN("unknown", null);

        String name;
        String identifierPath;

        private Launchers(String name, String identifierPath) {
            this.name = name;
            this.identifierPath = identifierPath;
        }

        public String getName() {
            return this.name;
        }

        public boolean exists(File minecraftDir) {
            return Files.exists(Paths.get(minecraftDir + this.identifierPath, new String[0]), new LinkOption[0]);
        }
    }
}

