/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.inventory.container.machine;

import cofh.core.inventory.container.TileContainer;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.tileentity.TileCoFH;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.container.slot.SlotRemoveOnly;
import cofh.lib.inventory.wrapper.InvWrapperCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.tileentity.machine.MachineCrafterTile;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MachineCrafterContainer
extends TileContainer {
    public final MachineCrafterTile tile;
    private final CraftingInventory craftMatrix = new CraftingInventory((Container)this, 3, 3);
    private final CraftResultInventory craftResult = new CraftResultInventory();
    private final PlayerEntity player;
    private final boolean initialized;

    public MachineCrafterContainer(int windowId, World world, BlockPos pos, PlayerInventory inventory, PlayerEntity player) {
        super(TExpReferences.MACHINE_CRAFTER_CONTAINER, windowId, world, pos, inventory, player);
        int i;
        this.tile = (MachineCrafterTile)world.func_175625_s(pos);
        InvWrapperCoFH tileInv = new InvWrapperCoFH((SimpleItemInv)this.tile.getItemInv());
        this.player = inventory.field_70458_d;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotCoFH(tileInv, i, 8 + i * 18, 77));
        }
        this.func_75146_a((Slot)new SlotRemoveOnly((IInventory)tileInv, 9, 143, 21));
        this.func_75146_a((Slot)new SlotCoFH(tileInv, 10, 8, 53));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotFalseCopy((IInventory)this.craftMatrix, j + i * 3, 53 + j * 18, 17 + i * 18));
            }
        }
        this.func_75146_a((Slot)new CraftingResultSlot(player, this.craftMatrix, (IInventory)this.craftResult, 0, 114, 44){

            public boolean func_82869_a(PlayerEntity player) {
                return false;
            }
        });
        this.bindAugmentSlots((IInventory)tileInv, 21, this.tile.augSize());
        this.bindPlayerInventory(inventory);
        if (Utils.isServerWorld((World)world)) {
            for (i = 0; i < 9; ++i) {
                this.craftMatrix.func_70299_a(i, this.tile.getItemInv().get(11 + i));
            }
            this.calcCraftingGrid();
        }
        this.initialized = true;
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 108;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.tile.clearRecipeChanges();
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        this.slotChangedCraftingGrid();
    }

    protected int getMergeableSlotCount() {
        return this.baseTile.invSize() - 9 - 1;
    }

    public boolean hasValidRecipe() {
        return !this.craftResult.func_70301_a(0).func_190926_b();
    }

    public void setRecipe() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.tile.getItemInv().set(11 + i, this.craftMatrix.func_70301_a(i));
        }
        TileConfigPacket.sendToServer((TileCoFH)this.tile);
        this.tile.clearRecipeChanges();
    }

    protected void slotChangedCraftingGrid() {
        if (this.syncing || !this.initialized) {
            return;
        }
        World world = this.tile.func_145831_w();
        if (Utils.isServerWorld((World)world)) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)this.player;
            ItemStack stack = ItemStack.field_190927_a;
            Optional possibleRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, world);
            if (possibleRecipe.isPresent()) {
                stack = ((ICraftingRecipe)possibleRecipe.get()).func_77572_b((IInventory)this.craftMatrix);
                this.craftResult.func_193056_a(this.craftResult.func_193055_i());
            }
            this.tile.markRecipeChanges();
            this.craftResult.func_70299_a(0, stack);
            playerMP.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 20, stack));
        } else {
            this.calcCraftingGrid();
            this.tile.markRecipeChanges();
        }
    }

    protected void calcCraftingGrid() {
        Optional possibleRecipe;
        World world = this.tile.func_145831_w();
        ItemStack stack = ItemStack.field_190927_a;
        if (world != null && (possibleRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, world)).isPresent()) {
            this.craftResult.func_193056_a((IRecipe)possibleRecipe.get());
            stack = ((ICraftingRecipe)possibleRecipe.get()).func_77572_b((IInventory)this.craftMatrix);
        }
        this.craftResult.func_70299_a(0, stack);
    }
}

