/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.core.util.recipes.machine.SmelterRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineSmelterScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SmelterRecipeCategory
extends ThermalRecipeCategory<SmelterRecipe> {
    public SmelterRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineSmelterScreen.TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_SMELTER_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends SmelterRecipe> getRecipeClass() {
        return SmelterRecipe.class;
    }

    public void setIngredients(SmelterRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
    }

    public void setRecipe(IRecipeLayout layout, SmelterRecipe recipe, IIngredients ingredients) {
        int i;
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        List catalysts = SmelterRecipeManager.instance().getCatalysts();
        for (int i2 = 0; i2 < outputs.size(); ++i2) {
            float chance = ((Float)recipe.getOutputItemChances().get(i2)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputs.get(i2)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 42, 5);
        guiItemStacks.init(1, true, 24, 5);
        guiItemStacks.init(2, true, 60, 5);
        guiItemStacks.init(3, true, 42, 41);
        guiItemStacks.init(4, false, 114, 14);
        guiItemStacks.init(5, false, 132, 14);
        guiItemStacks.init(6, false, 114, 32);
        guiItemStacks.init(7, false, 132, 32);
        for (i = 0; i < inputs.size(); ++i) {
            guiItemStacks.set(i, (List)inputs.get(i));
        }
        if (recipe.isCatalyzable()) {
            guiItemStacks.set(3, catalysts);
        }
        for (i = 0; i < outputs.size(); ++i) {
            guiItemStacks.set(i + 4, (List)outputs.get(i));
        }
        this.addCatalyzedItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 4);
    }

    public void draw(SmelterRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 84, 23);
        this.speedBackground.draw(matrixStack, 43, 24);
        this.progress.draw(matrixStack, 84, 23);
        this.speed.draw(matrixStack, 43, 24);
    }
}

