/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owmii.lib.util.NBT;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;

public class Builder {
    private final ReactorTile reactor;
    private List<BlockPos> queue = new ArrayList<BlockPos>();
    public boolean built;
    private int delay = 5;

    public Builder(ReactorTile reactor) {
        this.reactor = reactor;
    }

    public void read(CompoundNBT nbt) {
        this.built = nbt.func_74767_n("built");
        if (!this.built) {
            this.queue = (List)NBT.readPosList((CompoundNBT)nbt, (String)"queue_pos", new ArrayList());
        }
    }

    public void write(CompoundNBT nbt) {
        nbt.func_74757_a("built", this.built);
        if (!this.built) {
            NBT.writePosList((CompoundNBT)nbt, this.queue, (String)"queue_pos");
        }
    }

    public boolean isDone(World world) {
        if (this.built) {
            return true;
        }
        if (!this.queue.isEmpty()) {
            if (this.delay-- <= 0) {
                Iterator<BlockPos> itr = this.queue.iterator();
                while (itr.hasNext()) {
                    BlockPos pos = itr.next();
                    BlockState state = ((ReactorBlock)this.reactor.getBlock()).func_176223_P();
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ReactorBlock.CORE, (Comparable)Boolean.valueOf(false)), 3);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (!(tileEntity instanceof ReactorPartTile)) continue;
                    ReactorPartTile part = (ReactorPartTile)tileEntity;
                    part.setCorePos(this.reactor.func_174877_v());
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.reactor.func_195044_w()));
                    itr.remove();
                    this.delay = 5;
                    return false;
                }
            }
        } else {
            for (Direction side : Direction.values()) {
                if (side.equals((Object)Direction.DOWN)) continue;
                BlockPos pos = this.reactor.func_174877_v().func_177972_a(side).func_177981_b(side.equals((Object)Direction.UP) ? 2 : 0);
                TileEntity tileEntity = world.func_175625_s(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setExtractor(true);
            }
            for (BlockPos pos : this.getPosList()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setBuilt(true);
                part.sync();
            }
            this.built = true;
            this.reactor.sync();
        }
        return false;
    }

    public void shuffle() {
        this.queue.addAll(this.getPosList());
        Collections.shuffle(this.queue);
    }

    public void demolish(World world) {
        List<BlockPos> list = this.getPosList();
        list.add(this.reactor.func_174877_v());
        int count = 0;
        for (BlockPos blockPos : list) {
            if (!world.func_180495_p(blockPos).func_177230_c().equals(this.reactor.getBlock())) continue;
            ++count;
            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        Block.func_180635_a((World)world, (BlockPos)this.reactor.func_174877_v(), (ItemStack)new ItemStack((IItemProvider)this.reactor.getBlock(), count + this.queue.size()));
        world.func_180501_a(this.reactor.func_174877_v(), Blocks.field_150350_a.func_176223_P(), 3);
        this.queue.clear();
    }

    public List<BlockPos> getPosList() {
        BlockPos pos = this.reactor.func_174877_v();
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 3, 1)).map(BlockPos::func_185334_h).filter(pos1 -> !pos1.equals((Object)pos)).collect(Collectors.toList());
    }
}

