/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import owmii.lib.block.AbstractTickableTile;
import owmii.lib.block.IInventoryHolder;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.registry.IVariant;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.recipe.Recipes;

public class EnergizingOrbTile
extends AbstractTickableTile<IVariant.Single, EnergizingOrbBlock>
implements IInventoryHolder {
    private final Energy buffer = Energy.create((long)0L);
    private boolean containRecipe;
    @Nullable
    private EnergizingRecipe recipe;

    public EnergizingOrbTile() {
        super(Tiles.ENERGIZING_ORB);
        this.inv.set(7);
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.buffer.read(nbt, "buffer", true, false);
        this.buffer.setTransfer(this.buffer.getCapacity());
        this.containRecipe = nbt.func_74767_n("contain_recipe");
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        this.buffer.write(nbt, "buffer", true, false);
        nbt.func_74757_a("contain_recipe", this.containRecipe);
        return super.writeSync(nbt);
    }

    public Direction getOrbUp() {
        BlockState state;
        if (this.field_145850_b != null && (state = this.func_195044_w()).func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d();
        }
        return Direction.UP;
    }

    public Vector3d getOrbCenter() {
        Direction up = this.getOrbUp();
        double scale = 0.1;
        return Vector3d.func_237489_a_((Vector3i)this.field_174879_c).func_72441_c((double)up.func_82601_c() * scale, (double)up.func_96559_d() * scale, (double)up.func_82599_e() * scale);
    }

    @Nullable
    public EnergizingRecipe currRecipe() {
        return this.recipe;
    }

    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        this.checkRecipe();
    }

    public void onSlotChanged(int index) {
        if (!this.isRemote()) {
            this.buffer.setCapacity(0L);
            this.buffer.setStored(0L);
            this.buffer.setTransfer(0L);
            this.checkRecipe();
        }
    }

    private void checkRecipe() {
        if (this.field_145850_b != null && !this.isRemote()) {
            Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(Recipes.ENERGIZING, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.getInventory()), this.field_145850_b);
            if (recipe.isPresent()) {
                this.recipe = (EnergizingRecipe)recipe.get();
                this.buffer.setCapacity(this.recipe.getEnergy());
                this.buffer.setTransfer(this.recipe.getEnergy());
            } else {
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
            }
            this.setContainRecipe(recipe.isPresent());
            this.sync(1);
        }
    }

    public long fillEnergy(long amount) {
        long filled = Math.min(this.buffer.getEmpty(), amount);
        if (this.field_145850_b != null && this.recipe != null) {
            this.buffer.produce(filled);
            if (this.buffer.isFull()) {
                ItemStack stack = this.recipe.func_77571_b();
                this.inv.clear();
                this.inv.setStackInSlot(0, stack.func_77946_l());
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
                this.func_70296_d();
            }
            this.sync(5);
        }
        return filled;
    }

    public boolean containRecipe() {
        return this.containRecipe;
    }

    public void setContainRecipe(boolean containRecipe) {
        this.containRecipe = containRecipe;
    }

    public Energy getBuffer() {
        return this.buffer;
    }

    public int getSlotLimit(int index) {
        return index == 0 ? 64 : 1;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return slot == 0;
    }

    public boolean canInsert(int index, ItemStack stack) {
        return index != 0 && this.inv.getStackInSlot(0).func_190926_b() && this.inv.getStackInSlot(index).func_190926_b();
    }
}

